/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import apoc.util.Util;
import apoc.util.s3.S3Params;
import com.amazonaws.regions.Regions;
import java.net.URL;
import java.util.Map;
import java.util.Objects;

public class S3ParamsExtractor {
    private static final String PROTOCOL = "s3";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private static final String SESSION_TOKEN = "sessionToken";

    public static S3Params extract(URL url) throws IllegalArgumentException {
        if (!PROTOCOL.equals(url.getProtocol())) {
            throw new IllegalArgumentException("Unsupported protocol '" + url.getProtocol() + "'");
        }
        String accessKey = null;
        String secretKey = null;
        String sessionToken = null;
        if (url.getUserInfo() != null) {
            String[] credentials = url.getUserInfo().split(":");
            if (credentials.length > 1) {
                accessKey = credentials[0];
                secretKey = credentials[1];
            }
            if (credentials.length > 2) {
                sessionToken = credentials[2];
            }
        } else {
            Map<String, String> params = Util.getRequestParameter(url.getQuery());
            if (Objects.nonNull(params)) {
                if (params.containsKey(ACCESS_KEY)) {
                    accessKey = params.get(ACCESS_KEY);
                }
                if (params.containsKey(SECRET_KEY)) {
                    secretKey = params.get(SECRET_KEY);
                }
                if (params.containsKey(SESSION_TOKEN)) {
                    sessionToken = params.get(SESSION_TOKEN);
                }
            }
        }
        Object endpoint = url.getHost();
        Integer slashIndex = url.getPath().lastIndexOf("/");
        if (slashIndex <= 0) {
            throw new IllegalArgumentException("Invalid url. Must be:\n's3://accessKey:secretKey@endpoint:port/bucket/key' or\n's3://endpoint:port/bucket/key?accessKey=accessKey&secretKey=secretKey'");
        }
        String key = url.getPath().substring(slashIndex + 1);
        String bucket = url.getPath().substring(1, slashIndex);
        String region = null;
        if (Objects.nonNull(endpoint)) {
            for (Regions r : Regions.values()) {
                if (!((String)endpoint).toLowerCase().contains(r.getName().toLowerCase())) continue;
                region = r.getName().toLowerCase();
                break;
            }
            if (Objects.nonNull(region)) {
                if (!((String)endpoint).contains("amazonaws.com")) {
                    endpoint = ((String)endpoint).substring(((String)endpoint).indexOf(".") + 1);
                }
                if (region.toLowerCase().equals(((String)endpoint).toLowerCase())) {
                    endpoint = "";
                }
            }
        }
        if (url.getPort() != 80 && url.getPort() != 443 && url.getPort() > 0) {
            endpoint = (String)endpoint + ":" + url.getPort();
        }
        if (Objects.nonNull(endpoint) && ((String)endpoint).isEmpty()) {
            endpoint = null;
        }
        return new S3Params(accessKey, secretKey, sessionToken, (String)endpoint, bucket, key, region);
    }
}

