/*
 * Decompiled with CFR 0.152.
 */
package apoc.uuid;

import apoc.util.Util;
import java.util.Collections;
import java.util.Map;

public class UuidConfig {
    private boolean addToExistingNodes;
    private String uuidProperty;
    private static final String DEFAULT_UUID_PROPERTY = "uuid";
    private static final boolean DEFAULT_ADD_TO_EXISTING_NODES = true;

    public UuidConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.addToExistingNodes = Util.toBoolean(config.getOrDefault("addToExistingNodes", true));
        this.uuidProperty = config.getOrDefault("uuidProperty", DEFAULT_UUID_PROPERTY).toString();
    }

    public UuidConfig() {
    }

    public boolean isAddToExistingNodes() {
        return this.addToExistingNodes;
    }

    public void setAddToExistingNodes(boolean addToExistingNodes) {
        this.addToExistingNodes = addToExistingNodes;
    }

    public String getUuidProperty() {
        return this.uuidProperty;
    }

    public void setUuidProperty(String uuidProperty) {
        this.uuidProperty = uuidProperty;
    }
}

