/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.service.RandomService;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateAndTime {
    private RandomService randomService;

    public DateAndTime(RandomService randomService) {
        this.randomService = randomService;
    }

    public Date future(int atMost, TimeUnit unit) {
        Date now = new Date();
        Date aBitLaterThanNow = new Date(now.getTime() + 1000L);
        return this.future(atMost, unit, aBitLaterThanNow);
    }

    public Date future(int atMost, TimeUnit unit, Date referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return new Date(futureMillis += 1L + this.randomService.nextLong(upperBound - 1L));
    }

    public Date past(int atMost, TimeUnit unit) {
        Date now = new Date();
        Date aBitEarlierThanNow = new Date(now.getTime() - 1000L);
        return this.past(atMost, unit, aBitEarlierThanNow);
    }

    public Date past(int atMost, TimeUnit unit, Date referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return new Date(futureMillis -= 1L + this.randomService.nextLong(upperBound - 1L));
    }

    public Date between(Date from, Date to) throws IllegalArgumentException {
        if (to.before(from)) {
            throw new IllegalArgumentException("Invalid date range, the upper bound date is before the lower bound.");
        }
        long offsetMillis = this.randomService.nextLong(to.getTime() - from.getTime());
        return new Date(from.getTime() + offsetMillis);
    }
}

