/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.service.RandomService;
import java.math.BigDecimal;

public class Number {
    private final RandomService randomService;

    public Number(RandomService randomService) {
        this.randomService = randomService;
    }

    public int randomDigit() {
        return this.randomService.nextInt(9);
    }

    public int randomDigitNotZero() {
        return this.randomService.nextInt(8) + 1;
    }

    public long numberBetween(int min, long max) {
        return this.numberBetween((long)min, max);
    }

    public int numberBetween(int min, int max) {
        return this.randomService.nextInt(max - min) + min;
    }

    public long numberBetween(long min, long max) {
        return this.randomService.nextLong(max - min) + min;
    }

    public long randomNumber(int numberOfDigits, boolean strict) {
        long max = (long)Math.pow(10.0, numberOfDigits);
        if (strict) {
            long min = (long)Math.pow(10.0, numberOfDigits - 1);
            return this.randomService.nextLong(max - min) + min;
        }
        return this.randomService.nextLong(max);
    }

    public long randomNumber() {
        int numberOfDigits = this.randomService.nextInt(8) + 1;
        return this.randomNumber(numberOfDigits, false);
    }

    public double randomDouble(int maxNumberOfDecimals, int min, int max) {
        double value = (double)min + (double)(max - min) * this.randomService.nextDouble();
        return new BigDecimal(value).setScale(maxNumberOfDecimals, 6).doubleValue();
    }
}

