/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker.service;

import com.github.javafaker.Resolver;
import com.github.javafaker.service.FakeValuesServiceInterface;
import com.github.javafaker.service.LocaleDoesNotExistException;
import com.github.javafaker.service.RandomService;
import com.mifmif.common.regex.Generex;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class FakeValuesService
implements FakeValuesServiceInterface {
    private static final char[] METHOD_NAME_DELIMITERS = new char[]{'_'};
    private final Map<String, Object> fakeValuesMap;
    private final RandomService randomService;

    public FakeValuesService(Locale locale, RandomService randomService) {
        String filename = locale.getLanguage();
        InputStream stream = this.findStream(filename);
        if (stream == null) {
            filename = filename + "-" + locale.getCountry();
            stream = this.findStream(filename);
        }
        if (stream == null) {
            throw new LocaleDoesNotExistException(String.format("%s could not be found, does not have a corresponding yaml file", locale));
        }
        Map valuesMap = (Map)new Yaml().load(stream);
        valuesMap = (Map)valuesMap.get(filename);
        this.fakeValuesMap = (Map)valuesMap.get("faker");
        this.randomService = randomService;
    }

    private InputStream findStream(String filename) {
        String filenameWithExtension = "/" + filename + ".yml";
        InputStream streamOnClass = this.getClass().getResourceAsStream(filenameWithExtension);
        if (streamOnClass != null) {
            return streamOnClass;
        }
        return this.getClass().getClassLoader().getResourceAsStream(filenameWithExtension);
    }

    @Override
    public Object fetch(String key) {
        List valuesArray = (List)this.fetchObject(key);
        return valuesArray.get(this.nextInt(valuesArray.size()));
    }

    @Override
    public String fetchString(String key) {
        return (String)this.fetch(key);
    }

    @Override
    public String safeFetch(String key) {
        Object o = this.fetchObject(key);
        if (o == null) {
            return "";
        }
        if (o instanceof List) {
            List values = (List)o;
            return (String)values.get(this.randomService.nextInt(values.size()));
        }
        return (String)o;
    }

    @Override
    public Object fetchObject(String key) {
        String[] path = key.split("\\.");
        Object currentValue = this.fakeValuesMap;
        for (String pathSection : path) {
            currentValue = currentValue.get(pathSection);
        }
        return currentValue;
    }

    @Override
    public String numerify(String numberString) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numberString.length(); ++i) {
            if (numberString.charAt(i) == '#') {
                sb.append(this.nextInt(10));
                continue;
            }
            sb.append(numberString.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public String bothify(String string) {
        return this.letterify(this.numerify(string));
    }

    @Override
    public String regexify(String regex) {
        Generex generex = new Generex(regex);
        generex.setSeed(this.randomService.nextLong());
        return generex.random();
    }

    @Override
    public String letterify(String letterString) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < letterString.length(); ++i) {
            if (letterString.charAt(i) == '?') {
                sb.append((char)(97 + this.nextInt(26)));
                continue;
            }
            sb.append(letterString.charAt(i));
        }
        return sb.toString();
    }

    private int nextInt(int n) {
        return this.randomService.nextInt(n);
    }

    @Override
    public String resolve(String key, Object current, Resolver resolver) {
        String unresolvedString = this.safeFetch(key);
        String regex = "#\\{[A-Za-z_.]+\\}";
        Matcher matcher = Pattern.compile(regex).matcher(unresolvedString);
        while (matcher.find()) {
            String matched = matcher.group();
            String strippedMatched = matched.replace('#', ' ').replace('{', ' ').replace('}', ' ').trim();
            boolean isFirstLetterCapital = Character.isUpperCase(strippedMatched.charAt(0));
            String objectWithMethodToResolve = isFirstLetterCapital ? strippedMatched : current.getClass().getSimpleName() + "." + strippedMatched;
            String resolvedValue = resolver.resolve(objectWithMethodToResolve);
            unresolvedString = unresolvedString.replace(matched, resolvedValue);
        }
        return unresolvedString;
    }
}

