/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.client.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1Structured
extends ASN1Object {
    private ASN1Object[] content;
    private int contentIndex = 0;

    protected ASN1Structured(ASN1Identifier id) {
        this(id, 10);
    }

    protected ASN1Structured(ASN1Identifier id, int size) {
        super(id);
        this.content = new ASN1Object[size];
    }

    protected ASN1Structured(ASN1Identifier id, ASN1Object[] newContent, int size) {
        super(id);
        this.content = newContent;
        this.contentIndex = size;
    }

    public final void encode(ASN1Encoder enc, OutputStream out) throws IOException {
        enc.encode(this, out);
    }

    protected final void decodeStructured(ASN1Decoder dec, InputStream in, int len) throws IOException {
        int[] componentLen = new int[1];
        while (len > 0) {
            this.add(dec.decode(in, componentLen));
            len -= componentLen[0];
        }
    }

    public final ASN1Object[] toArray() {
        ASN1Object[] cloneArray = new ASN1Object[this.contentIndex];
        System.arraycopy(this.content, 0, cloneArray, 0, this.contentIndex);
        return cloneArray;
    }

    public final void add(ASN1Object value) {
        if (this.contentIndex == this.content.length) {
            int newSize = this.contentIndex + this.contentIndex;
            Debug.trace("ASN1", "ASN1Structured: Expanding Array from " + this.contentIndex + " to " + newSize);
            ASN1Object[] newArray = new ASN1Object[newSize];
            System.arraycopy(this.content, 0, newArray, 0, this.contentIndex);
            this.content = newArray;
        }
        this.content[this.contentIndex++] = value;
    }

    public final void set(int index, ASN1Object value) {
        if (index >= this.contentIndex || index < 0) {
            throw new IndexOutOfBoundsException("ASN1Structured: get: index " + index + ", size " + this.contentIndex);
        }
        this.content[index] = value;
    }

    public final ASN1Object get(int index) {
        if (index >= this.contentIndex || index < 0) {
            throw new IndexOutOfBoundsException("ASN1Structured: set: index " + index + ", size " + this.contentIndex);
        }
        return this.content[index];
    }

    public final int size() {
        return this.contentIndex;
    }

    public String toString(String type) {
        StringBuffer sb = new StringBuffer();
        sb.append(type);
        for (int i = 0; i < this.contentIndex; ++i) {
            sb.append(this.content[i]);
            if (i == this.contentIndex - 1) continue;
            sb.append(", ");
        }
        sb.append(" }");
        return super.toString() + sb.toString();
    }
}

