/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.client;

import com.novell.ldap.client.Debug;
import java.util.Vector;

public class RespControlVector
extends Vector {
    public RespControlVector(int cap, int incr) {
        super(cap, incr);
    }

    public final synchronized void registerResponseControl(String oid, Class controlClass) {
        Debug.trace("Controls", "Registered Control with OID " + oid + " for class " + controlClass.toString());
        this.addElement(new RegisteredControl(oid, controlClass));
    }

    public final synchronized Class findResponseControl(String searchOID) throws NoSuchFieldException {
        RegisteredControl ctl = null;
        for (int i = 0; i < this.elementCount; ++i) {
            ctl = (RegisteredControl)this.elementData[i];
            if (ctl == null) {
                throw new NoSuchFieldException();
            }
            if (ctl.myOID.compareTo(searchOID) != 0) continue;
            Debug.trace("Controls", "Returned control matched a registered control");
            return ctl.myClass;
        }
        Debug.trace("Controls", "Returned control did not match any registered control. Treating as ordinary LDAPControl.");
        return null;
    }

    private class RegisteredControl {
        public String myOID;
        public Class myClass;

        public RegisteredControl(String oid, Class controlClass) {
            this.myOID = oid;
            this.myClass = controlClass;
        }
    }
}

