/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import apoc.export.cypher.formatter.CypherFormatterUtils;
import java.util.Iterator;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;

public class DatabaseSubGraph
implements SubGraph {
    private final Transaction transaction;

    public DatabaseSubGraph(Transaction transaction) {
        this.transaction = transaction;
    }

    public static SubGraph from(Transaction transaction) {
        return new DatabaseSubGraph(transaction);
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.transaction.getAllNodes();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.transaction.getAllRelationships();
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.transaction.getRelationshipById(relationship.getId()) != null;
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return this.transaction.schema().getIndexes();
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        return this.transaction.schema().getConstraints();
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        return this.transaction.schema().getConstraints(label);
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        return this.transaction.schema().getConstraints(type);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        return this.transaction.schema().getIndexes(label);
    }

    @Override
    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.transaction.getAllRelationshipTypesInUse();
    }

    @Override
    public Iterable<Label> getAllLabelsInUse() {
        return this.transaction.getAllLabelsInUse();
    }

    @Override
    public long countsForRelationship(Label start, RelationshipType type, Label end) {
        String startNode = CypherFormatterUtils.cypherNode(start);
        String endNode = CypherFormatterUtils.cypherNode(end);
        String relationship = String.format("[r:%s]", type.name());
        return (Long)this.transaction.execute(String.format("MATCH %s-%s->%s RETURN count(r) AS count", startNode, relationship, endNode)).columnAs("count").next();
    }

    @Override
    public long countsForNode(Label label) {
        return (Long)this.transaction.execute(String.format("MATCH (n:%s) RETURN count(n) AS count", label.name())).columnAs("count").next();
    }

    @Override
    public Iterator<Node> findNodes(Label label) {
        return this.transaction.findNodes(label);
    }
}

