/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableResultsColumn;
import schemacrawler.crawl.MutableResultsColumns;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.Retriever;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schema.Schema;
import schemacrawler.utility.JavaSqlTypes;
import sf.util.Utility;

final class ResultsRetriever
implements Retriever {
    private final ResultSetMetaData resultsMetaData;

    ResultsRetriever(ResultSet resultSet) throws SQLException {
        Objects.requireNonNull(resultSet, "Cannot retrieve metadata for null results");
        this.resultsMetaData = resultSet.getMetaData();
    }

    ResultsColumns retrieveResults() throws SQLException {
        JavaSqlTypes javaSqlTypes = new JavaSqlTypes();
        MutableResultsColumns resultColumns = new MutableResultsColumns("");
        MutableCatalog catalog = new MutableCatalog("results");
        int columnCount = this.resultsMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String catalogName = this.resultsMetaData.getCatalogName(i);
            String schemaName = this.resultsMetaData.getSchemaName(i);
            String tableName = this.resultsMetaData.getTableName(i);
            if (Utility.isBlank(tableName)) {
                tableName = "";
            }
            Schema schema = catalog.addSchema(catalogName, schemaName);
            MutableTable table = new MutableTable(schema, tableName);
            catalog.addTable(table);
            String databaseSpecificTypeName = this.resultsMetaData.getColumnTypeName(i);
            int javaSqlType = this.resultsMetaData.getColumnType(i);
            String columnClassName = this.resultsMetaData.getColumnClassName(i);
            MutableColumnDataType columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName);
            columnDataType.setJavaSqlType(javaSqlTypes.valueOf(javaSqlType));
            columnDataType.setTypeMappedClass(columnClassName);
            columnDataType.setPrecision(this.resultsMetaData.getPrecision(i));
            int scale = this.resultsMetaData.getScale(i);
            columnDataType.setMaximumScale(scale);
            columnDataType.setMinimumScale(scale);
            String columnName = this.resultsMetaData.getColumnName(i);
            MutableResultsColumn column = new MutableResultsColumn(table, columnName);
            column.setOrdinalPosition(i);
            column.setColumnDataType(columnDataType);
            column.setLabel(this.resultsMetaData.getColumnLabel(i));
            column.setDisplaySize(this.resultsMetaData.getColumnDisplaySize(i));
            boolean isNullable = this.resultsMetaData.isNullable(i) == 1;
            column.setAutoIncrement(this.resultsMetaData.isAutoIncrement(i));
            column.setCaseSensitive(this.resultsMetaData.isCaseSensitive(i));
            column.setCurrency(this.resultsMetaData.isCurrency(i));
            column.setDefinitelyWritable(this.resultsMetaData.isDefinitelyWritable(i));
            column.setNullable(isNullable);
            column.setReadOnly(this.resultsMetaData.isReadOnly(i));
            column.setSearchable(this.resultsMetaData.isSearchable(i));
            column.setSigned(this.resultsMetaData.isSigned(i));
            column.setWritable(this.resultsMetaData.isWritable(i));
            resultColumns.addColumn(column);
        }
        return resultColumns;
    }
}

