/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.counts;

import java.util.Objects;
import schemacrawler.schema.Table;

public final class CountsUtility {
    private static final int UNKNOWN_TABLE_ROW_COUNT = -1;
    private static final String TABLE_ROW_COUNT_KEY = "schemacrawler.table.count";

    public static final long getRowCount(Table table) {
        if (table == null) {
            return -1L;
        }
        long tableCount = table.getAttribute(TABLE_ROW_COUNT_KEY, -1L);
        return tableCount;
    }

    public static String getRowCountMessage(Number number) {
        Objects.requireNonNull(number, "No number provided");
        long longValue = number.longValue();
        if (longValue <= 0L) {
            return "empty";
        }
        return String.format("%,d rows", longValue);
    }

    public static final String getRowCountMessage(Table table) {
        return CountsUtility.getRowCountMessage(CountsUtility.getRowCount(table));
    }

    public static final boolean hasRowCount(Table table) {
        return table != null && table.hasAttribute(TABLE_ROW_COUNT_KEY);
    }

    static void addRowCountToTable(Table table, long rowCount) {
        if (table != null) {
            if (rowCount >= 0L) {
                table.setAttribute(TABLE_ROW_COUNT_KEY, rowCount);
            } else {
                table.removeAttribute(TABLE_ROW_COUNT_KEY);
            }
        }
    }

    private CountsUtility() {
    }
}

