/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.EmptyInputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public abstract class ExecutableCommandProvider
implements CommandProvider {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ExecutableCommandProvider.class.getName());
    private final Collection<String> supportedCommands;
    private final String executableClassName;

    public ExecutableCommandProvider(Collection<String> supportedCommands, String executableClassName) {
        this.supportedCommands = supportedCommands;
        this.executableClassName = executableClassName;
    }

    @Override
    public InputResource getHelp() {
        String helpResource = "/help/DefaultExecutable.txt";
        try {
            return new ClasspathInputResource("/help/DefaultExecutable.txt");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Could not load help resource <%s>", "/help/DefaultExecutable.txt"), (Throwable)e);
            return new EmptyInputResource();
        }
    }

    @Override
    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) throws SchemaCrawlerException {
        SchemaCrawlerCommand scCommand;
        Class<?> commandExecutableClass;
        try {
            commandExecutableClass = Class.forName(this.executableClassName);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaCrawlerException("Could not load class " + this.executableClassName, e);
        }
        try {
            scCommand = (SchemaCrawlerCommand)commandExecutableClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, new StringFormat("Could not instantiate using default constructor for class <%s>", this.executableClassName));
            try {
                Constructor<?> constructor = commandExecutableClass.getConstructor(String.class);
                scCommand = (SchemaCrawlerCommand)constructor.newInstance(command);
            }
            catch (Exception e1) {
                throw new SchemaCrawlerException("Could not instantiate executable for command '" + command + "'", e1);
            }
        }
        return scCommand;
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        return this.supportedCommands.contains(command);
    }

    public String toString() {
        return this.executableClassName;
    }
}

