/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.commandlineparser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import schemacrawler.schemacrawler.Config;

public class CommandLineArgumentsParser {
    private static final String DASH = "-";
    private final String[] args;
    private final Config optionsMap;
    private final List<String> nonOptionArguments;

    public CommandLineArgumentsParser(String[] args) {
        this.args = Objects.requireNonNull(args, "No arguments provided");
        this.optionsMap = new Config();
        this.nonOptionArguments = new ArrayList<String>();
    }

    public List<String> getNonOptionArguments() {
        return this.nonOptionArguments;
    }

    public Config getOptionsMap() {
        return this.optionsMap;
    }

    public void parse() {
        ArrayDeque<String> argsList = new ArrayDeque<String>(Arrays.asList(this.args));
        while (true) {
            String currentArg;
            if ((currentArg = (String)argsList.pollFirst()) == null) {
                if (!argsList.isEmpty()) continue;
                break;
            }
            if (currentArg.startsWith(DASH)) {
                if (currentArg.contains("=")) {
                    String[] split2 = currentArg.split("=", 2);
                    String option = split2[0].replaceAll("^-+", "");
                    String value = split2.length == 2 ? split2[1] : null;
                    this.optionsMap.put(option, value);
                    continue;
                }
                String option = currentArg.replaceAll("^-+", "");
                String value = (String)argsList.peekFirst();
                if (value != null && value.startsWith(DASH)) {
                    this.optionsMap.put(option, null);
                    continue;
                }
                this.optionsMap.put(option, (String)argsList.pollFirst());
                continue;
            }
            this.nonOptionArguments.add(currentArg);
        }
    }

    public String toString() {
        return Arrays.toString(this.args);
    }
}

