/*
 * Decompiled with CFR 0.152.
 */
package apoc.bolt;

import apoc.bolt.BoltConfig;
import apoc.bolt.ClosedAwareDelegatingIterator;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.MapUtil;
import apoc.util.UriResolver;
import apoc.util.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Bolt {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.bolt.load(url-or-key, kernelTransaction, params, config) - access to other databases via bolt for read")
    public Stream<RowResult> load(@Name(value="url") String url, @Name(value="kernelTransaction") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        BoltConfig boltConfig = new BoltConfig(config);
        UriResolver uri = new UriResolver(url, "bolt");
        uri.initialize();
        return this.withDriver(uri.getConfiguredUri(), uri.getToken(), boltConfig.getDriverConfig(), driver -> this.withSession((Driver)driver, boltConfig.getSessionConfig(), session -> {
            if (boltConfig.isAddStatistics()) {
                org.neo4j.driver.Result statementResult = session.run(statement, params);
                SummaryCounters counters = statementResult.consume().counters();
                return Stream.of(new RowResult(this.toMap(counters)));
            }
            return this.getRowResultStream(boltConfig.isVirtual(), (Session)session, params, statement);
        }));
    }

    private <T> Stream<T> withDriver(URI uri, AuthToken token, Config config, Function<Driver, Stream<T>> function) {
        Driver driver = GraphDatabase.driver((URI)uri, (AuthToken)token, (Config)config);
        return (Stream)function.apply(driver).onClose(() -> driver.close());
    }

    private <T> Stream<T> withSession(Driver driver, SessionConfig sessionConfig, Function<Session, Stream<T>> function) {
        Session session = driver.session(sessionConfig);
        return (Stream)function.apply(session).onClose(() -> session.close());
    }

    private <T> Stream<T> withSession(Driver driver, Function<Session, Stream<T>> function) {
        Session session = driver.session();
        return (Stream)function.apply(session).onClose(() -> session.close());
    }

    private <T> Stream<T> withTransaction(Session session, Function<Transaction, Stream<T>> function) {
        Transaction transaction = session.beginTransaction();
        return (Stream)((Stream)function.apply(transaction).onClose(() -> transaction.commit())).onClose(() -> transaction.close());
    }

    @Procedure(value="apoc.bolt.load.fromLocal", mode=Mode.WRITE)
    public Stream<RowResult> fromLocal(@Name(value="url") String url, @Name(value="localStatement") String localStatement, @Name(value="remoteStatement") String remoteStatement, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        BoltConfig boltConfig = new BoltConfig(config);
        UriResolver uri = new UriResolver(url, "bolt");
        uri.initialize();
        return this.withDriver(uri.getConfiguredUri(), uri.getToken(), boltConfig.getDriverConfig(), driver -> this.withSession((Driver)driver, boltConfig.getSessionConfig(), session -> {
            try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
                Result localResult = tx.execute(localStatement, boltConfig.getLocalParams());
                String withColumns = "WITH " + localResult.columns().stream().map(c -> "$" + c + " AS " + c).collect(Collectors.joining(", ")) + "\n";
                HashMap nodesCache = new HashMap();
                ArrayList<RowResult> response = new ArrayList<RowResult>();
                while (localResult.hasNext()) {
                    org.neo4j.driver.Result statementResult;
                    Map row = localResult.next();
                    if (boltConfig.isStreamStatements()) {
                        String statement = (String)row.get("statement");
                        if (StringUtils.isBlank((CharSequence)statement)) continue;
                        Map params = Collections.singletonMap("params", row.getOrDefault("params", Collections.emptyMap()));
                        statementResult = session.run(statement, params);
                    } else {
                        statementResult = session.run(withColumns + remoteStatement, row);
                    }
                    if (boltConfig.isStreamStatements()) {
                        response.add(new RowResult(this.toMap(statementResult.consume().counters())));
                        continue;
                    }
                    response.addAll(statementResult.stream().map(record -> this.buildRowResult((Record)record, nodesCache, boltConfig.isVirtual())).collect(Collectors.toList()));
                }
                Stream stream = response.stream();
                return stream;
            }
        }));
    }

    @Procedure
    @Description(value="apoc.bolt.execute(url-or-key, kernelTransaction, params, config) - access to other databases via bolt for read")
    public Stream<RowResult> execute(@Name(value="url") String url, @Name(value="kernelTransaction") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        HashMap<String, Object> configuration = new HashMap<String, Object>(config);
        configuration.put("readOnly", false);
        return this.load(url, statement, params, configuration);
    }

    private RowResult buildRowResult(Record record, Map<Long, Object> nodesCache, boolean virtual) {
        return new RowResult(record.asMap(value -> {
            Object entity = value.asObject();
            if (entity instanceof Node) {
                return this.toNode(entity, virtual, nodesCache);
            }
            if (entity instanceof Relationship) {
                return this.toRelationship(entity, virtual, nodesCache);
            }
            if (entity instanceof Path) {
                return this.toPath(entity, virtual, nodesCache);
            }
            return entity;
        }));
    }

    private Stream<RowResult> getRowResultStream(boolean virtual, Session session, Map<String, Object> params, String statement) {
        HashMap nodesCache = new HashMap();
        return this.withTransaction(session, tx -> {
            ClosedAwareDelegatingIterator iterator = new ClosedAwareDelegatingIterator(tx.run(statement, params));
            return Iterators.stream(iterator).map(record -> this.buildRowResult((Record)record, nodesCache, virtual));
        });
    }

    private Object toNode(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        Value internalValue = ((InternalEntity)value).asValue();
        Node node = internalValue.asNode();
        if (virtual) {
            ArrayList labels2 = new ArrayList();
            node.labels().forEach(l -> labels2.add(Label.label((String)l)));
            VirtualNode virtualNode = new VirtualNode(node.id(), labels2.toArray(new Label[0]), node.asMap());
            nodesCache.put(node.id(), virtualNode);
            return virtualNode;
        }
        return Util.map((Object[])new Object[]{"entityType", internalValue.type().name(), "labels", node.labels(), "id", node.id(), "properties", node.asMap()});
    }

    private Object toRelationship(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        Value internalValue = ((InternalEntity)value).asValue();
        Relationship relationship = internalValue.asRelationship();
        if (virtual) {
            VirtualNode start = (VirtualNode)nodesCache.getOrDefault(relationship.startNodeId(), new VirtualNode(relationship.startNodeId()));
            VirtualNode end = (VirtualNode)nodesCache.getOrDefault(relationship.endNodeId(), new VirtualNode(relationship.endNodeId()));
            VirtualRelationship virtualRelationship = new VirtualRelationship(relationship.id(), (org.neo4j.graphdb.Node)start, (org.neo4j.graphdb.Node)end, RelationshipType.withName((String)relationship.type()), relationship.asMap());
            return virtualRelationship;
        }
        return Util.map((Object[])new Object[]{"entityType", internalValue.type().name(), "type", relationship.type(), "id", relationship.id(), "start", relationship.startNodeId(), "end", relationship.endNodeId(), "properties", relationship.asMap()});
    }

    private Object toPath(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        LinkedList entityList = new LinkedList();
        Value internalValue = ((InternalPath)value).asValue();
        internalValue.asPath().forEach(p -> {
            entityList.add(this.toNode(p.start(), virtual, nodesCache));
            entityList.add(this.toRelationship(p.relationship(), virtual, nodesCache));
            entityList.add(this.toNode(p.end(), virtual, nodesCache));
        });
        return entityList;
    }

    private Map<String, Object> toMap(SummaryCounters resultSummary) {
        return MapUtil.map((Object[])new Object[]{"nodesCreated", resultSummary.nodesCreated(), "nodesDeleted", resultSummary.nodesDeleted(), "labelsAdded", resultSummary.labelsAdded(), "labelsRemoved", resultSummary.labelsRemoved(), "relationshipsCreated", resultSummary.relationshipsCreated(), "relationshipsDeleted", resultSummary.relationshipsDeleted(), "propertiesSet", resultSummary.propertiesSet(), "constraintsAdded", resultSummary.constraintsAdded(), "constraintsRemoved", resultSummary.constraintsRemoved(), "indexesAdded", resultSummary.indexesAdded(), "indexesRemoved", resultSummary.indexesRemoved()});
    }
}

