/*
 * Decompiled with CFR 0.152.
 */
package apoc.date;

import apoc.Extended;
import apoc.date.Date;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class DateExpiry {
    @Procedure(mode=Mode.WRITE, deprecatedBy="apoc.ttl.expire")
    @Description(value="CALL apoc.date.expire(node,time,'time-unit') - expire node at specified time by setting :TTL label and `ttl` property")
    @Deprecated
    public void expire(@Name(value="node") Node node, @Name(value="time") long time, @Name(value="timeUnit") String timeUnit) {
        node.addLabel(Label.label((String)"TTL"));
        node.setProperty("ttl", (Object)Date.unit((String)timeUnit).toMillis(time));
    }

    @Procedure(mode=Mode.WRITE, deprecatedBy="apoc.ttl.expireIn")
    @Description(value="CALL apoc.date.expireIn(node,time,'time-unit') - expire node after specified length of time time by setting :TTL label and `ttl` property")
    @Deprecated
    public void expireIn(@Name(value="node") Node node, @Name(value="timeDelta") long time, @Name(value="timeUnit") String timeUnit) {
        node.addLabel(Label.label((String)"TTL"));
        node.setProperty("ttl", (Object)(System.currentTimeMillis() + Date.unit((String)timeUnit).toMillis(time)));
    }
}

