/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Pools;
import apoc.load.LoadDirectoryItem;
import apoc.util.FileUtils;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;

public class LoadDirectoryHandler
extends LifecycleAdapter {
    public final Map<LoadDirectoryItem, Future> storage = new ConcurrentHashMap<LoadDirectoryItem, Future>();
    private final Log log;
    private final GraphDatabaseService db;
    private final Pools pools;

    public LoadDirectoryHandler(GraphDatabaseService db, Log log, Pools pools) {
        this.db = db;
        this.log = log;
        this.pools = pools;
    }

    private static WatchEvent.Kind[] fromListStringToKindArray(List<String> listenEventType) {
        WatchEvent.Kind[] kinds = (WatchEvent.Kind[])listenEventType.stream().map(item -> {
            switch (item) {
                case "CREATE": {
                    return StandardWatchEventKinds.ENTRY_CREATE;
                }
                case "MODIFY": {
                    return StandardWatchEventKinds.ENTRY_MODIFY;
                }
                case "DELETE": {
                    return StandardWatchEventKinds.ENTRY_DELETE;
                }
            }
            throw new UnsupportedOperationException("Event Type not supported: " + item);
        }).toArray(WatchEvent.Kind[]::new);
        return kinds;
    }

    public void start() {
    }

    public void stop() {
        this.removeAll();
    }

    public void remove(String name) {
        LoadDirectoryItem loadDirectoryItem = new LoadDirectoryItem(name);
        this.remove(loadDirectoryItem);
    }

    private void remove(LoadDirectoryItem loadDirectoryItem) {
        Future removed = this.storage.remove(loadDirectoryItem);
        if (removed == null) {
            String name = loadDirectoryItem.getName();
            throw new RuntimeException("Listener with name: " + name + " doesn't exist");
        }
        removed.cancel(true);
    }

    public void add(LoadDirectoryItem loadDirectoryItem) {
        this.storage.compute(loadDirectoryItem, (k, v) -> {
            if (v != null) {
                try {
                    v.cancel(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.pools.getDefaultExecutorService().submit(this.createListener(loadDirectoryItem));
        });
    }

    public Stream<LoadDirectoryItem.LoadDirectoryResult> list() {
        return Collections.unmodifiableMap(this.storage).keySet().stream().map(LoadDirectoryItem::toResult);
    }

    public void removeAll() {
        HashSet<LoadDirectoryItem> keys = new HashSet<LoadDirectoryItem>(this.storage.keySet());
        keys.forEach(this::remove);
    }

    private Runnable createListener(LoadDirectoryItem item) {
        return () -> {
            try {
                WatchService watcher = FileSystems.getDefault().newWatchService();
                try {
                    LoadDirectoryItem.LoadDirectoryConfig config = item.getConfig();
                    FileUtils.getPathFromUrlString((String)item.getUrlDir()).register(watcher, LoadDirectoryHandler.fromListStringToKindArray(config.getListenEventType()));
                    item.setStatusRunning();
                    while (true) {
                        WatchKey watchKey;
                        if ((watchKey = watcher.take()) != null) {
                            watchKey.reset();
                            Path dir = (Path)watchKey.watchable();
                            for (WatchEvent<?> event : watchKey.pollEvents()) {
                                Path filePath = dir.resolve((Path)event.context());
                                WildcardFileFilter fileFilter = new WildcardFileFilter(item.getPattern());
                                String fileName = filePath.getFileName().toString();
                                boolean matchFilePattern = fileFilter.accept(dir.toFile(), fileName);
                                if (!matchFilePattern) continue;
                                try (Transaction tx = this.db.beginTx();){
                                    String stringFileDirectory = LoadDirectoryHandler.getPathDependingOnUseNeo4jConfig(dir.toString());
                                    String stringFilePath = LoadDirectoryHandler.getPathDependingOnUseNeo4jConfig(filePath.toString());
                                    tx.execute(item.getCypher(), Map.of("fileName", fileName, "filePath", stringFilePath, "fileDirectory", stringFileDirectory, "listenEventType", event.kind().name().replace("ENTRY_", "")));
                                    tx.commit();
                                }
                            }
                        }
                        Thread.sleep(config.getInterval());
                    }
                }
                catch (Throwable throwable) {
                    if (watcher != null) {
                        try {
                            watcher.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.warn(String.format("Error while executing procedure with name %s . The status of the directory listener is changed to ERROR. Type `call apoc.load.directory.async.list` to more details.", item.getName()));
                item.setError(ExceptionUtils.getStackTrace((Throwable)e));
                return;
            }
        };
    }

    public static String getPathDependingOnUseNeo4jConfig(String urlFile) {
        return FileUtils.isImportUsingNeo4jConfig() ? StringUtils.replaceOnce((String)urlFile, (String)(FileUtils.getDirImport() + File.separator), (String)"") : urlFile;
    }
}

