/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.mongodb.MongoDBUtils;
import apoc.util.Util;
import java.util.Collections;
import java.util.Map;
import org.bson.Document;

public class MongoDbConfig {
    private final boolean compatibleValues;
    private final boolean extractReferences;
    private final boolean objectIdAsMap;
    private final String idFieldName;
    private final String collection;
    private final Document project;
    private final Document sort;
    private final int skip;
    private final int limit;

    public MongoDbConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.compatibleValues = Util.toBoolean((Object)config.getOrDefault("compatibleValues", true));
        this.extractReferences = Util.toBoolean((Object)config.getOrDefault("extractReferences", false));
        this.objectIdAsMap = Util.toBoolean((Object)config.getOrDefault("objectIdAsMap", true));
        this.idFieldName = (String)config.getOrDefault("idFieldName", "_id");
        this.collection = (String)config.getOrDefault("collection", "");
        this.project = MongoDBUtils.getDocument(config.get("project"));
        this.sort = MongoDBUtils.getDocument(config.get("sort"));
        this.skip = Util.toInteger((Object)config.getOrDefault("skip", 0));
        this.limit = Util.toInteger((Object)config.getOrDefault("limit", 0));
    }

    public boolean isCompatibleValues() {
        return this.compatibleValues;
    }

    public boolean isExtractReferences() {
        return this.extractReferences;
    }

    public boolean isObjectIdAsMap() {
        return this.objectIdAsMap;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public String getCollection() {
        return this.collection;
    }

    public Document getSort() {
        return this.sort;
    }

    public Document getProject() {
        return this.project;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }
}

