/*
 * Decompiled with CFR 0.152.
 */
package apoc.systemdb.metadata;

import apoc.SystemLabels;
import apoc.SystemPropertyKeys;
import apoc.export.util.ProgressReporter;
import apoc.systemdb.SystemDbConfig;
import apoc.systemdb.metadata.ExportDataVirtualization;
import apoc.systemdb.metadata.ExportFunction;
import apoc.systemdb.metadata.ExportProcedure;
import apoc.systemdb.metadata.ExportTrigger;
import apoc.systemdb.metadata.ExportUuid;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.helpers.collection.Pair;

public interface ExportMetadata {
    public List<Pair<String, String>> export(Node var1, ProgressReporter var2);

    default public String getFileName(Node node, String prefix) {
        Object dbName = (String)node.getProperty(SystemPropertyKeys.database.name(), null);
        dbName = StringUtils.isEmpty((CharSequence)dbName) ? "" : "." + (String)dbName;
        return prefix + (String)dbName;
    }

    public static enum Type {
        CypherProcedure(new ExportProcedure()),
        CypherFunction(new ExportFunction()),
        Uuid(new ExportUuid()),
        Trigger(new ExportTrigger()),
        DataVirtualizationCatalog(new ExportDataVirtualization());

        private final ExportMetadata exportMetadata;

        private Type(ExportMetadata exportMetadata) {
            this.exportMetadata = exportMetadata;
        }

        public List<Pair<String, String>> export(Node node, ProgressReporter progressReporter) {
            return this.exportMetadata.export(node, progressReporter);
        }

        public static Optional<Type> from(Label label, SystemDbConfig config) {
            String name = label.name();
            if (name.equalsIgnoreCase(SystemLabels.Procedure.name())) {
                return Type.get(CypherProcedure, config);
            }
            if (name.equalsIgnoreCase(SystemLabels.Function.name())) {
                return Type.get(CypherFunction, config);
            }
            if (name.equalsIgnoreCase(SystemLabels.ApocTrigger.name())) {
                return Type.get(Trigger, config);
            }
            if (name.equalsIgnoreCase(SystemLabels.ApocUuid.name())) {
                return Type.get(Uuid, config);
            }
            if (name.equalsIgnoreCase(SystemLabels.DataVirtualizationCatalog.name())) {
                return Type.get(DataVirtualizationCatalog, config);
            }
            return Optional.empty();
        }

        private static Optional<Type> get(Type cypherProcedure, SystemDbConfig config) {
            return config.getFeatures().contains(cypherProcedure.name()) ? Optional.of(cypherProcedure) : Optional.empty();
        }
    }
}

