/*
 * Decompiled with CFR 0.152.
 */
package apoc.systemdb.metadata;

import apoc.SystemPropertyKeys;
import apoc.export.util.ProgressReporter;
import apoc.systemdb.metadata.ExportMetadata;
import apoc.util.Util;
import java.util.HashMap;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.helpers.collection.Pair;

public class ExportUuid
implements ExportMetadata {
    @Override
    public List<Pair<String, String>> export(Node node, ProgressReporter progressReporter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String labelName = (String)node.getProperty(SystemPropertyKeys.label.name());
        String property = (String)node.getProperty(SystemPropertyKeys.propertyName.name());
        map.put("addToSetLabels", node.getProperty(SystemPropertyKeys.addToSetLabel.name(), null));
        map.put("uuidProperty", property);
        String uuidConfig = Util.toCypherMap(map);
        String schemaStatement = String.format("CREATE CONSTRAINT IF NOT EXISTS ON (n:%s) ASSERT n.%s IS UNIQUE;\n", labelName, property);
        String statement = String.format("CALL apoc.uuid.install('%s', %s);", labelName, uuidConfig);
        progressReporter.nextRow();
        return List.of(Pair.of((Object)this.getFileName(node, ExportMetadata.Type.Uuid.name() + ".schema"), (Object)schemaStatement), Pair.of((Object)this.getFileName(node, ExportMetadata.Type.Uuid.name()), (Object)statement));
    }
}

