/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.jar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ClassWriter;
import net.bytebuddy.jar.asm.commons.ClassRemapper;
import net.bytebuddy.jar.asm.commons.Remapper;
import net.bytebuddy.jar.asm.commons.SimpleRemapper;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class JarBuilder {
    public static byte[] classCompiledBytes(String fileName) throws IOException {
        try (InputStream in = JarBuilder.class.getClassLoader().getResourceAsStream(fileName);){
            Objects.requireNonNull(in);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (in.available() > 0) {
                out.write(in.read());
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static List<String> createJarFor(Path pth, Class<?> ... classes) {
        assert (classes.length > 0);
        File file = pth.toFile();
        ArrayList<String> remappedClassNames = new ArrayList<String>(classes.length);
        try {
            try (DynamicType.Unloaded<?> cls = JarBuilder.subclass(classes[0]);){
                cls.toJar(file);
                remappedClassNames.add(cls.getTypeDescription().getName());
            }
            for (int i = 1; i < classes.length; ++i) {
                try (DynamicType.Unloaded<?> cls = JarBuilder.subclass(classes[i]);){
                    cls.inject(file);
                    remappedClassNames.add(cls.getTypeDescription().getName());
                    continue;
                }
            }
        }
        catch (IOException exc) {
            throw new RuntimeException("Could not write %s to %s.".formatted(Arrays.toString(classes), pth), exc);
        }
        return remappedClassNames;
    }

    private static DynamicType.Unloaded<?> subclass(Class<?> cls) {
        return new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.isDeclaredBy(cls)).intercept((Implementation)SuperMethodCall.INSTANCE).attribute((MethodAttributeAppender.Factory)MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER).make();
    }

    private static String toInternalIdentifier(String className) {
        return className.replace('.', '/');
    }

    private static String fromInternalIdentifier(String className) {
        return className.replace('/', '.');
    }

    private static String convertToJarEntryPath(String className) {
        return JarBuilder.toInternalIdentifier(className) + ".class";
    }

    private static HashMap<String, String> generateNameMappings(List<Class<?>> classes, String newSuffix) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Class<?> clazz : classes) {
            String fqn = JarBuilder.toInternalIdentifier(clazz.getName());
            String packageName = fqn.substring(0, fqn.lastIndexOf(47));
            String className = fqn.substring(fqn.lastIndexOf(47) + 1);
            String[] innerClasses = className.split("\\$");
            StringBuilder updatedName = new StringBuilder();
            updatedName.append(packageName).append("/");
            for (int j = 0; j < innerClasses.length; ++j) {
                updatedName.append(innerClasses[j]).append(newSuffix);
                if (j == innerClasses.length - 1) continue;
                updatedName.append("$");
            }
            String newFQN = updatedName.toString();
            mappings.put(fqn, newFQN);
        }
        return mappings;
    }

    private static byte[] rewriteClass(Class<?> clazz, HashMap<String, String> mappings) throws IOException {
        String originalClassEntryPath = JarBuilder.convertToJarEntryPath(clazz.getName());
        InputStream classByteStream = clazz.getClassLoader().getResourceAsStream(originalClassEntryPath);
        if (classByteStream == null) {
            throw new IOException("Could not find class resource " + originalClassEntryPath);
        }
        ClassReader classReader = new ClassReader(classByteStream);
        ClassWriter classWriter = new ClassWriter(3);
        ClassRemapper remapper = new ClassRemapper((ClassVisitor)classWriter, (Remapper)new SimpleRemapper(mappings));
        classReader.accept((ClassVisitor)remapper, 8);
        return classWriter.toByteArray();
    }

    public static List<String> createJarWithRenamedClassesFor(Path pth, List<Class<?>> includedClasses, List<Class<?>> renamedButNotIncludedClasses) {
        assert (!includedClasses.isEmpty());
        String newSuffix = Long.toString(Instant.now().getEpochSecond());
        ArrayList allClasses = new ArrayList(includedClasses);
        allClasses.addAll(renamedButNotIncludedClasses);
        HashMap<String, String> mappings = JarBuilder.generateNameMappings(allClasses, newSuffix);
        ArrayList<String> remappedClassNames = new ArrayList<String>(allClasses.size());
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        try (FileOutputStream fs = new FileOutputStream(pth.toFile(), false);
             JarOutputStream jarStream = new JarOutputStream((OutputStream)fs, manifest);){
            for (Class<?> clazz : includedClasses) {
                String mappedName = mappings.get(JarBuilder.toInternalIdentifier(clazz.getName()));
                remappedClassNames.add(JarBuilder.fromInternalIdentifier(mappedName));
                String mappedClassEntryPath = JarBuilder.convertToJarEntryPath(mappedName);
                JarEntry entry = new JarEntry(mappedClassEntryPath);
                entry.setTime(Instant.now().toEpochMilli());
                jarStream.putNextEntry(entry);
                byte[] rewrittenClassBytes = JarBuilder.rewriteClass(clazz, mappings);
                jarStream.write(rewrittenClassBytes);
                jarStream.closeEntry();
            }
        }
        catch (IOException exc) {
            throw new RuntimeException("Could not write %s to %s.".formatted(allClasses, pth), exc);
        }
        return remappedClassNames;
    }

    public static List<String> createJarWithRenamedClassesFor(Path pth, List<Class<?>> includedClasses) {
        return JarBuilder.createJarWithRenamedClassesFor(pth, includedClasses, List.of());
    }
}

