/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.harness.extensionpackage.MyUnmanagedExtension;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.server.HTTP;
import org.neo4j.tooling.GlobalGraphOperations;

public class InProcessBuilderTest {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(InProcessBuilderTest.class);
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldLaunchAServerInSpecifiedDirectory() throws Exception {
        File workDir = new File(this.testDir.directory(), "specific");
        workDir.mkdir();
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)workDir).newServer();){
            MatcherAssert.assertThat((Object)HTTP.GET((String)server.httpURI().toString()).status(), (Matcher)CoreMatchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)workDir.list().length, (Matcher)CoreMatchers.equalTo((Object)1));
        }
        MatcherAssert.assertThat((String)Arrays.toString(workDir.list()), (Object)workDir.list().length, (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldAllowCustomServerAndDbConfig() throws Exception {
        this.trustAllSSLCerts();
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)this.testDir.directory()).withConfig(Configurator.WEBSERVER_HTTPS_ENABLED_PROPERTY_KEY, "true").withConfig(ServerSettings.tls_certificate_file.name(), this.testDir.file("cert").getAbsolutePath()).withConfig("org.neo4j.server.webserver.https.keystore.location", this.testDir.file("keystore").getAbsolutePath()).withConfig(ServerSettings.tls_key_file.name(), this.testDir.file("key").getAbsolutePath()).withConfig(GraphDatabaseSettings.dense_node_threshold, "20").newServer();){
            MatcherAssert.assertThat((Object)HTTP.GET((String)server.httpsURI().toString()).status(), (Matcher)CoreMatchers.equalTo((Object)200));
            this.assertDBConfig(server, "20", GraphDatabaseSettings.dense_node_threshold.name());
        }
    }

    @Test
    public void shouldMountUnmanagedExtensionsByClass() throws Exception {
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)this.testDir.directory()).withExtension("/path/to/my/extension", MyUnmanagedExtension.class).newServer();){
            MatcherAssert.assertThat((Object)HTTP.GET((String)(server.httpURI().toString() + "path/to/my/extension/myExtension")).status(), (Matcher)CoreMatchers.equalTo((Object)234));
        }
    }

    @Test
    public void shouldMountUnmanagedExtensionsByPackage() throws Exception {
        try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)this.testDir.directory()).withExtension("/path/to/my/extension", "org.neo4j.harness.extensionpackage").newServer();){
            MatcherAssert.assertThat((Object)HTTP.GET((String)(server.httpURI().toString() + "path/to/my/extension/myExtension")).status(), (Matcher)CoreMatchers.equalTo((Object)234));
        }
    }

    @Test
    public void shouldFindFreePort() throws Exception {
        try (ServerControls firstServer = TestServerBuilders.newInProcessBuilder((File)this.testDir.directory()).newServer();
             ServerControls secondServer = TestServerBuilders.newInProcessBuilder((File)this.testDir.directory()).newServer();){
            MatcherAssert.assertThat((Object)secondServer.httpURI().getPort(), (Matcher)CoreMatchers.not((Object)firstServer.httpURI().getPort()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRunBuilderOnExistingStoreDir() throws Exception {
        Path dir = Files.createTempDirectory(this.getClass().getSimpleName() + "_shouldRunBuilderOnExistingStorageDir", new FileAttribute[0]);
        try {
            GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(dir.toString());
            try {
                db.execute("create ()");
            }
            finally {
                db.shutdown();
            }
            try (ServerControls server = TestServerBuilders.newInProcessBuilder((File)this.testDir.directory()).copyFrom(dir.toFile()).newServer();
                 Transaction tx = server.graph().beginTx();){
                ResourceIterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)server.graph()).getAllNodes();
                Assert.assertTrue((IteratorUtil.count((Iterable)allNodes) > 0 ? 1 : 0) != 0);
                server.graph().createNode();
                tx.success();
            }
            db = new TestGraphDatabaseFactory().newEmbeddedDatabase(dir.toString());
            try {
                var4_5 = null;
                try (Transaction tx = db.beginTx();){
                    Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()));
                    tx.success();
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
            }
            finally {
                db.shutdown();
            }
        }
        finally {
            FileUtils.forceDelete((File)dir.toFile());
        }
    }

    @Test
    public void shouldFailWhenProvidingANonDirectoryAsSource() throws IOException {
        File notADirectory = File.createTempFile("prefix", "suffix");
        Assert.assertFalse((boolean)notADirectory.isDirectory());
        try (ServerControls server = TestServerBuilders.newInProcessBuilder().copyFrom(notADirectory).newServer();){
            Assert.fail((String)"server should not start");
        }
        catch (RuntimeException rte) {
            Throwable cause = rte.getCause();
            Assert.assertTrue((boolean)(cause instanceof IOException));
            Assert.assertTrue((boolean)cause.getMessage().contains("exists but is not a directory"));
        }
    }

    private void assertDBConfig(ServerControls server, String expected, String key) throws JsonParseException {
        JsonNode beans = HTTP.GET((String)(server.httpURI().toString() + "db/manage/server/jmx/domain/org.neo4j/")).get("beans");
        JsonNode configurationBean = this.findNamedBean(beans, "Configuration").get("attributes");
        boolean foundKey = false;
        for (JsonNode attribute : configurationBean) {
            if (!attribute.get("name").asText().equals(key)) continue;
            MatcherAssert.assertThat((Object)attribute.get("value").asText(), (Matcher)CoreMatchers.equalTo((Object)expected));
            foundKey = true;
            break;
        }
        if (!foundKey) {
            Assert.fail((String)("No config key '" + key + "'."));
        }
    }

    private JsonNode findNamedBean(JsonNode beans, String beanName) {
        for (JsonNode bean : beans) {
            JsonNode name = bean.get("name");
            if (name == null || !name.asText().endsWith(",name=" + beanName)) continue;
            return bean;
        }
        throw new NoSuchElementException();
    }

    private void trustAllSSLCerts() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }
}

