/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.internal.InProcessServerControls;
import org.neo4j.io.fs.FileUtils;

public class Fixtures {
    private final List<String> fixtureStatements = new LinkedList<String>();
    private final List<Function<GraphDatabaseService, Void>> fixtureFunctions = new LinkedList<Function<GraphDatabaseService, Void>>();
    private final String cypherSuffix = "cyp";
    private final FileFilter cypherFileOrDirectoryFilter = file -> {
        if (file.isDirectory()) {
            return true;
        }
        String[] split = file.getName().split("\\.");
        String suffix = split[split.length - 1];
        return suffix.equals("cyp");
    };

    public void add(File fixturePath) {
        try {
            if (fixturePath.isDirectory()) {
                for (File file : fixturePath.listFiles(this.cypherFileOrDirectoryFilter)) {
                    this.add(file);
                }
                return;
            }
            this.add(FileUtils.readTextFile((File)fixturePath, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read fixture file '" + fixturePath.getAbsolutePath() + "': " + e.getMessage(), e);
        }
    }

    public void add(String statement) {
        if (statement.trim().length() > 0) {
            this.fixtureStatements.add(statement);
        }
    }

    public void add(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.fixtureFunctions.add(fixtureFunction);
    }

    public void applyTo(InProcessServerControls controls) {
        GraphDatabaseService db = controls.graph();
        for (String string : this.fixtureStatements) {
            Transaction tx = db.beginTx();
            Throwable throwable = null;
            try {
                db.execute(string);
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
        for (Function function : this.fixtureFunctions) {
            function.apply(db);
        }
    }
}

