/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.harness.internal.AbstractInProcessServerBuilder;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;

public class InProcessServerBuilder
extends AbstractInProcessServerBuilder {
    public InProcessServerBuilder() {
        this(new File(System.getProperty("java.io.tmpdir")));
    }

    public InProcessServerBuilder(File workingDir) {
        super(workingDir);
    }

    @Override
    protected GraphFactory createGraphFactory(Config config) {
        return new CommunityGraphFactory();
    }

    @Override
    protected AbstractNeoServer createNeoServer(GraphFactory graphFactory, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new CommunityNeoServer(config, graphFactory, dependencies);
    }
}

