/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.harness.Neo4j;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class InProcessNeo4j
implements Neo4j {
    private final Path serverFolder;
    private final Path userLogFile;
    private final Path internalLogFile;
    private final DatabaseManagementService managementService;
    private final Config config;
    private final Closeable additionalClosable;
    private ConnectorPortRegister connectorPortRegister;

    public InProcessNeo4j(Path serverFolder, Path userLogFile, Path internalLogFile, DatabaseManagementService managementService, Config config, Closeable additionalClosable) {
        this.serverFolder = serverFolder;
        this.userLogFile = userLogFile;
        this.internalLogFile = internalLogFile;
        this.managementService = managementService;
        this.config = config;
        this.additionalClosable = additionalClosable;
    }

    @Override
    public URI boltURI() {
        if (((Boolean)this.config.get(BoltConnector.enabled)).booleanValue()) {
            return this.connectorUri("bolt", ConnectorType.BOLT);
        }
        throw new IllegalStateException("Bolt connector is not configured");
    }

    @Override
    public URI httpURI() {
        if (((Boolean)this.config.get(HttpConnector.enabled)).booleanValue()) {
            return this.connectorUri("http", ConnectorType.HTTP);
        }
        throw new IllegalStateException("HTTP connector is not configured");
    }

    @Override
    public URI httpsURI() {
        if (((Boolean)this.config.get(HttpsConnector.enabled)).booleanValue()) {
            return this.connectorUri("https", ConnectorType.HTTPS);
        }
        throw new IllegalStateException("HTTPS connector is not configured");
    }

    public void start() {
        this.connectorPortRegister = this.connectorPortRegister();
    }

    @Override
    public void close() {
        this.managementService.shutdown();
        this.connectorPortRegister = null;
        try {
            this.additionalClosable.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (InProcessNeo4j.looksLikeMd5Hash(this.serverFolder.getFileName().toString())) {
                FileUtils.deleteDirectory((Path)this.serverFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean up test server directory.", e);
        }
    }

    @Override
    public void printLogs(PrintStream out) {
        InProcessNeo4j.printLog("User Log File", this.userLogFile, out);
        InProcessNeo4j.printLog("Internal Log File", this.internalLogFile, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLog(String description, Path file, PrintStream out) {
        if (file != null && Files.exists(file, new LinkOption[0])) {
            out.printf("---------- BEGIN %s ----------%n", description);
            try {
                Files.readAllLines(file).forEach(out::println);
            }
            catch (IOException ex) {
                try {
                    out.println("Unable to collect log files: " + ex.getMessage());
                    ex.printStackTrace(out);
                }
                catch (Throwable throwable) {
                    out.printf("---------- END %s ----------%n", description);
                    throw throwable;
                }
                out.printf("---------- END %s ----------%n", description);
            }
            out.printf("---------- END %s ----------%n", description);
        }
    }

    private static boolean looksLikeMd5Hash(String name) {
        return name.length() == 32;
    }

    @Override
    public DatabaseManagementService databaseManagementService() {
        return this.managementService;
    }

    @Override
    public GraphDatabaseService defaultDatabaseService() {
        return this.managementService.database((String)this.config.get(GraphDatabaseSettings.initial_default_database));
    }

    @Override
    public Configuration config() {
        return this.config;
    }

    private URI connectorUri(String scheme, ConnectorType connectorType) {
        HostnamePort hostPort = this.connectorPortRegister.getLocalAddress(connectorType);
        return URI.create(scheme + "://" + hostPort + "/");
    }

    private ConnectorPortRegister connectorPortRegister() {
        return (ConnectorPortRegister)((GraphDatabaseAPI)this.defaultDatabaseService()).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }
}

