/*
 * Decompiled with CFR 0.152.
 */
package org.neosearch.stringsearcher.trie;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.neosearch.stringsearcher.trie.Payload;

public class State<T> {
    private final int depth;
    private final State<T> rootState;
    private final Map<Character, State<T>> success = new HashMap<Character, State<T>>();
    private State<T> failure;
    private Set<Payload<T>> emits;

    public State() {
        this(0);
    }

    public State(int depth) {
        this.depth = depth;
        this.rootState = depth == 0 ? this : null;
    }

    private State<T> nextState(Character character, boolean ignoreRootState) {
        State<T> nextState = this.success.get(character);
        if (!ignoreRootState && nextState == null && this.rootState != null) {
            nextState = this.rootState;
        }
        return nextState;
    }

    public State<T> nextState(Character character) {
        return this.nextState(character, false);
    }

    public State<T> nextStateIgnoreRootState(Character character) {
        return this.nextState(character, true);
    }

    public State<T> addState(String keyword) {
        State<T> state = this;
        char[] cArray = keyword.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            state = state.addState(character);
        }
        return state;
    }

    public State<T> addState(Character character) {
        State<T> nextState = this.nextStateIgnoreRootState(character);
        if (nextState == null) {
            nextState = new State<T>(this.depth + 1);
            this.success.put(character, nextState);
        }
        return nextState;
    }

    public int getDepth() {
        return this.depth;
    }

    public void addEmit(Payload<T> payload) {
        if (this.emits == null) {
            this.emits = new TreeSet<Payload<T>>();
        }
        this.emits.add(payload);
    }

    public void addEmit(Collection<Payload<T>> emits) {
        for (Payload<T> emit : emits) {
            this.addEmit(emit);
        }
    }

    public Collection<Payload<T>> emit() {
        return this.emits == null ? Collections.emptyList() : this.emits;
    }

    public State<T> failure() {
        return this.failure;
    }

    public void setFailure(State<T> failState) {
        this.failure = failState;
    }

    public Collection<State<T>> getStates() {
        return this.success.values();
    }

    public Collection<Character> getTransitions() {
        return this.success.keySet();
    }
}

