/*
 * Decompiled with CFR 0.152.
 */
package org.neosearch.stringsearcher.trie.interval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neosearch.stringsearcher.trie.interval.Intervalable;

public class IntervalNode {
    private IntervalNode left;
    private IntervalNode right;
    private int point;
    private List<Intervalable> intervals = new ArrayList<Intervalable>();

    public IntervalNode(List<Intervalable> intervals) {
        this.point = this.determineMedian(intervals);
        ArrayList<Intervalable> toLeft = new ArrayList<Intervalable>();
        ArrayList<Intervalable> toRight = new ArrayList<Intervalable>();
        for (Intervalable interval : intervals) {
            if (interval.getEnd() < this.point) {
                toLeft.add(interval);
                continue;
            }
            if (interval.getStart() > this.point) {
                toRight.add(interval);
                continue;
            }
            this.intervals.add(interval);
        }
        if (toLeft.size() > 0) {
            this.left = new IntervalNode(toLeft);
        }
        if (toRight.size() > 0) {
            this.right = new IntervalNode(toRight);
        }
    }

    public int determineMedian(List<Intervalable> intervals) {
        int start = -1;
        int end = -1;
        for (Intervalable interval : intervals) {
            int currentStart = interval.getStart();
            int currentEnd = interval.getEnd();
            if (start == -1 || currentStart < start) {
                start = currentStart;
            }
            if (end != -1 && currentEnd <= end) continue;
            end = currentEnd;
        }
        return (start + end) / 2;
    }

    public List<Intervalable> findOverlaps(Intervalable interval) {
        ArrayList<Intervalable> overlaps = new ArrayList<Intervalable>();
        if (this.point < interval.getStart()) {
            this.addToOverlaps(interval, overlaps, this.findOverlappingRanges(this.right, interval));
            this.addToOverlaps(interval, overlaps, this.checkForOverlapsToTheRight(interval));
        } else if (this.point > interval.getEnd()) {
            this.addToOverlaps(interval, overlaps, this.findOverlappingRanges(this.left, interval));
            this.addToOverlaps(interval, overlaps, this.checkForOverlapsToTheLeft(interval));
        } else {
            this.addToOverlaps(interval, overlaps, this.intervals);
            this.addToOverlaps(interval, overlaps, this.findOverlappingRanges(this.left, interval));
            this.addToOverlaps(interval, overlaps, this.findOverlappingRanges(this.right, interval));
        }
        return overlaps;
    }

    protected void addToOverlaps(Intervalable interval, List<Intervalable> overlaps, List<Intervalable> newOverlaps) {
        for (Intervalable currentInterval : newOverlaps) {
            if (currentInterval.equals(interval)) continue;
            overlaps.add(currentInterval);
        }
    }

    protected List<Intervalable> checkForOverlapsToTheLeft(Intervalable interval) {
        return this.checkForOverlaps(interval, Direction.LEFT);
    }

    protected List<Intervalable> checkForOverlapsToTheRight(Intervalable interval) {
        return this.checkForOverlaps(interval, Direction.RIGHT);
    }

    protected List<Intervalable> checkForOverlaps(Intervalable interval, Direction direction) {
        ArrayList<Intervalable> overlaps = new ArrayList<Intervalable>();
        for (Intervalable currentInterval : this.intervals) {
            switch (direction) {
                case LEFT: {
                    if (currentInterval.getStart() > interval.getEnd()) break;
                    overlaps.add(currentInterval);
                    break;
                }
                case RIGHT: {
                    if (currentInterval.getEnd() < interval.getStart()) break;
                    overlaps.add(currentInterval);
                }
            }
        }
        return overlaps;
    }

    protected List<Intervalable> findOverlappingRanges(IntervalNode node, Intervalable interval) {
        return node == null ? Collections.emptyList() : node.findOverlaps(interval);
    }

    private static enum Direction {
        LEFT,
        RIGHT;

    }
}

