/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.openide.util.VectorIcon;

final class AquaVectorTabControlIcon
extends VectorIcon {
    private static final Map<Map.Entry<Integer, Integer>, Icon> INSTANCES = AquaVectorTabControlIcon.populateInstances();
    private final int buttonId;
    private final int buttonState;

    private static void populateOne(Map<Map.Entry<Integer, Integer>, Icon> toMap, int buttonId, int buttonState) {
        int height;
        int width;
        switch (buttonId) {
            case 1: {
                width = 14;
                height = 12;
                break;
            }
            case 11: 
            case 12: {
                width = 16;
                height = 16;
                break;
            }
            case 2: {
                width = 14;
                height = 12;
                break;
            }
            case 9: {
                width = 26;
                height = 15;
                break;
            }
            case 10: {
                width = 25;
                height = 15;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                width = 20;
                height = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        toMap.put(new AbstractMap.SimpleEntry<Integer, Integer>(buttonId, buttonState), (Icon)((Object)new AquaVectorTabControlIcon(buttonId, buttonState, width, height)));
    }

    private static Map<Map.Entry<Integer, Integer>, Icon> populateInstances() {
        LinkedHashMap<String, Integer> buttonIDs = new LinkedHashMap<String, Integer>();
        buttonIDs.put("close", 1);
        buttonIDs.put("pin", 2);
        buttonIDs.put("restore_group", 11);
        buttonIDs.put("slide_group", 12);
        buttonIDs.put("scroll_left", 9);
        buttonIDs.put("scroll_right", 10);
        buttonIDs.put("drop_down", 8);
        buttonIDs.put("maximize", 3);
        buttonIDs.put("restore", 4);
        LinkedHashMap<String, Integer> buttonStates = new LinkedHashMap<String, Integer>();
        buttonStates.put("default", 0);
        buttonStates.put("pressed", 1);
        buttonStates.put("disabled", 2);
        buttonStates.put("rollover", 3);
        LinkedHashMap<Map.Entry<Integer, Integer>, Icon> ret = new LinkedHashMap<Map.Entry<Integer, Integer>, Icon>();
        for (Map.Entry buttonID : buttonIDs.entrySet()) {
            for (Map.Entry buttonState : buttonStates.entrySet()) {
                AquaVectorTabControlIcon.populateOne(ret, (Integer)buttonID.getValue(), (Integer)buttonState.getValue());
            }
        }
        return Collections.unmodifiableMap(ret);
    }

    private AquaVectorTabControlIcon(int buttonId, int buttonState, int width, int height) {
        super(width, height);
        this.buttonId = buttonId;
        this.buttonState = buttonState;
    }

    public static Icon get(int buttonId, int buttonState) {
        return INSTANCES.get(new AbstractMap.SimpleEntry<Integer, Integer>(buttonId, buttonState));
    }

    protected void paintIcon(Component c, Graphics2D g, int width, int height, double scaling) {
        if (this.buttonId == 3 || this.buttonId == 4 || this.buttonId == 8 || this.buttonId == 9 || this.buttonId == 10) {
            this.paintLargerRectangleIcon(c, g, width, height, scaling);
        } else if (this.buttonId == 1) {
            this.paintSmallCircleCloseIcon(c, g, width, height, scaling);
        } else {
            this.paintSmallRectangleIcon(c, g, width, height, scaling);
        }
    }

    private void paintSmallCircleCloseIcon(Component c, Graphics2D g, int width, int height, double scaling) {
        double d = Math.min(width, height);
        Color bgColor = new Color(0, 0, 0, 0);
        Color fgColor = new Color(0, 0, 0, 168);
        if (this.buttonState == 3) {
            fgColor = Color.WHITE;
            bgColor = new Color(255, 35, 25, 215);
        } else if (this.buttonState == 1) {
            fgColor = Color.WHITE;
            bgColor = new Color(185, 43, 33, 215);
        } else if (this.buttonState == 2) {
            fgColor = new Color(0, 0, 0, 60);
        }
        if (bgColor.getAlpha() > 0) {
            double circPosX = ((double)width - d) / 2.0;
            double circPosY = ((double)height - d) / 2.0;
            Ellipse2D.Double bgCircle = new Ellipse2D.Double(circPosX, circPosY, d, d);
            g.setColor(bgColor);
            g.fill(bgCircle);
        }
        g.setColor(fgColor);
        double strokeWidth = 1.4 * scaling;
        double mx = (double)width / 2.0;
        double my = (double)height / 2.0;
        double cr = 0.45 * (d / 2.0);
        BasicStroke stroke = new BasicStroke((float)strokeWidth, 1, 1);
        Area area = new Area();
        area.add(new Area(stroke.createStrokedShape(new Line2D.Double(mx - cr, my - cr, mx + cr, my + cr))));
        area.add(new Area(stroke.createStrokedShape(new Line2D.Double(mx + cr, my - cr, mx - cr, my + cr))));
        g.fill(area);
    }

    private void paintSmallRectangleIcon(Component c, Graphics2D g, int width, int height, double scaling) {
        Color bgColor = new Color(0, 0, 0, 0);
        Color fgColor = new Color(0, 0, 0, 168);
        if (this.buttonState == 2) {
            fgColor = new Color(0, 0, 0, 60);
        } else if (this.buttonState == 3) {
            bgColor = new Color(0, 0, 0, 51);
            fgColor = Color.WHITE;
        } else if (this.buttonState == 1) {
            bgColor = new Color(0, 0, 0, 94);
            fgColor = Color.WHITE;
        }
        if (bgColor.getAlpha() > 0) {
            double arc = scaling * 6.0;
            RoundRectangle2D.Double bgRect = new RoundRectangle2D.Double(0.0, 0.0, width, height, arc, arc);
            g.setColor(bgColor);
            g.fill(bgRect);
        }
        g.setColor(fgColor);
        if (this.buttonId == 11) {
            int marginX = AquaVectorTabControlIcon.round((double)(3.0 * scaling));
            int marginY = AquaVectorTabControlIcon.round((double)(3.0 * scaling));
            int winWidth = AquaVectorTabControlIcon.round((double)(7.0 * scaling));
            int winHeight = AquaVectorTabControlIcon.round((double)(6.0 * scaling));
            int win1X = width - marginX - winWidth;
            int win1Y = marginY;
            int win2X = Math.min((int)Math.floor((double)win1X - 2.0 * scaling), marginX);
            int win2Y = Math.max((int)Math.ceil((double)win1Y + 2.0 * scaling), AquaVectorTabControlIcon.round((double)((double)height - 9.5 * scaling)));
            Area win1 = this.getWindowSymbol(scaling, win1X, win1Y, winWidth, winHeight);
            Area win2 = this.getWindowSymbol(scaling, win2X, win2Y, winWidth, winHeight);
            win1.subtract(new Area(win2.getBounds2D()));
            g.fill(win1);
            g.fill(win2);
        } else if (this.buttonId == 12) {
            int marginX = (int)(3.0 * scaling);
            int marginTop = (int)(4.0 * scaling);
            int marginBot = (int)(4.0 * scaling);
            Area win = this.getWindowSymbol(scaling, marginX, marginTop, width - 2 * marginX, height - marginTop - marginBot);
            g.fill(win);
        } else if (this.buttonId == 2) {
            int marginX = (int)(3.0 * scaling);
            int marginTop = (int)(2.0 * scaling);
            int marginBot = (int)(2.0 * scaling);
            Area win = this.getWindowSymbol(scaling, marginX, marginTop, width - 2 * marginX, height - marginTop - marginBot);
            g.fill(win);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void paintLargerRectangleIcon(Component c, Graphics2D g, int width, int height, double scaling) {
        int useWidth;
        Color symbolColor;
        Color borderColor;
        Color bgBotColor;
        Color bgTopColor;
        if (this.buttonState == 0) {
            bgTopColor = new Color(191, 191, 191);
            bgBotColor = new Color(135, 135, 135);
            borderColor = new Color(81, 81, 81);
            symbolColor = new Color(48, 48, 48);
        } else if (this.buttonState == 1) {
            bgTopColor = new Color(182, 182, 182);
            bgBotColor = new Color(129, 129, 129);
            borderColor = new Color(81, 81, 81);
            symbolColor = new Color(45, 45, 45);
        } else if (this.buttonState == 2) {
            bgTopColor = new Color(166, 166, 166);
            bgBotColor = new Color(137, 137, 137);
            borderColor = new Color(111, 111, 111);
            symbolColor = new Color(97, 97, 97);
        } else if (this.buttonState == 3) {
            bgTopColor = new Color(198, 198, 198);
            bgBotColor = new Color(149, 149, 149);
            borderColor = new Color(81, 81, 81);
            symbolColor = new Color(77, 77, 77);
        } else {
            throw new IllegalArgumentException();
        }
        int strokeWidth = AquaVectorTabControlIcon.round((double)(0.6 * scaling));
        g.setPaint(new GradientPaint(new Point2D.Double(0.0, strokeWidth), bgTopColor, new Point2D.Double(0.0, height - strokeWidth), bgBotColor));
        int rectExtraDir = this.buttonId == 9 ? 1 : (this.buttonId == 10 ? -1 : 0);
        double arc = scaling * 6.0;
        double rectExtraX = (double)rectExtraDir * ((double)strokeWidth + arc);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double((double)strokeWidth / 2.0 + (rectExtraDir < 0 ? rectExtraX : 0.0), (double)strokeWidth / 2.0, (double)(width - strokeWidth) + Math.abs(rectExtraX), height - strokeWidth, arc, arc);
        g.clipRect(0, 0, width, height);
        g.fill(rect);
        g.setStroke(new BasicStroke(strokeWidth, 1, 1));
        g.setColor(borderColor);
        g.draw(rect);
        if (this.buttonId == 9) {
            g.fillRect(width - strokeWidth, 0, strokeWidth, height);
            useWidth = width - strokeWidth;
        } else {
            useWidth = width;
        }
        g.setColor(symbolColor);
        if (this.buttonId == 3) {
            int marginX = AquaVectorTabControlIcon.round((double)(4.0 * scaling));
            int marginTop = AquaVectorTabControlIcon.round((double)(3.0 * scaling));
            int marginBot = AquaVectorTabControlIcon.round((double)(3.0 * scaling));
            g.fill(this.getWindowSymbol(scaling, marginX, marginTop, width - 2 * marginX, height - marginTop - marginBot));
        } else if (this.buttonId == 4) {
            int marginX = AquaVectorTabControlIcon.round((double)(4.0 * scaling));
            int marginTop = AquaVectorTabControlIcon.round((double)(2.0 * scaling));
            int marginBot = AquaVectorTabControlIcon.round((double)(2.5 * scaling));
            int winWidth = AquaVectorTabControlIcon.round((double)(9.0 * scaling));
            int winHeight = AquaVectorTabControlIcon.round((double)(7.0 * scaling));
            int win1X = width - marginX - winWidth;
            int win1Y = marginTop;
            int win2X = Math.min((int)Math.floor((double)win1X - 2.0 * scaling), marginX);
            int win2Y = Math.max(win1Y + AquaVectorTabControlIcon.round((double)(2.7 * scaling)), height - winHeight - marginBot);
            Area win1 = this.getWindowSymbol(scaling, win1X, win1Y, winWidth, winHeight);
            Area win2 = this.getWindowSymbol(scaling, win2X, win2Y, winWidth, winHeight);
            win1.subtract(new Area(win2.getBounds2D()));
            g.fill(win1);
            g.fill(win2);
        } else if (this.buttonId == 8 || this.buttonId == 9 || this.buttonId == 10) {
            double arrowHeight;
            double arrowWidth;
            if (this.buttonId == 9) {
                g.translate(AquaVectorTabControlIcon.round((double)(1.0 * scaling)), 0);
                g.rotate(1.5707963267948966, (double)useWidth / 2.0, (double)height / 2.0);
            } else if (this.buttonId == 10) {
                g.translate(-AquaVectorTabControlIcon.round((double)(1.0 * scaling)), 0);
                g.rotate(-1.5707963267948966, (double)useWidth / 2.0, (double)height / 2.0);
            }
            if (this.buttonId == 8) {
                arrowWidth = 6.0 * scaling;
                arrowHeight = 4.0 * scaling;
            } else {
                arrowWidth = 6.7 * scaling;
                arrowHeight = 3.8 * scaling;
            }
            int y = AquaVectorTabControlIcon.round((double)(((double)height - arrowHeight) / 2.0));
            double marginX = ((double)useWidth - arrowWidth) / 2.0;
            double arrowMidX = marginX + arrowWidth / 2.0;
            Path2D.Double arrowPath = new Path2D.Double();
            arrowPath.moveTo(arrowMidX - arrowWidth / 2.0, y);
            arrowPath.lineTo(arrowMidX, (double)y + arrowHeight);
            arrowPath.lineTo(arrowMidX + arrowWidth / 2.0, y);
            arrowPath.closePath();
            g.fill(arrowPath);
        }
    }

    private Area getWindowSymbol(double scaling, int x, int y, int width, int height) {
        int borderThickness = AquaVectorTabControlIcon.round((double)(0.8 * scaling));
        int titleBarHeight = this.buttonId == 12 || this.buttonId == 2 ? borderThickness : Math.max(AquaVectorTabControlIcon.round((double)(1.6 * scaling)), borderThickness + height / 7);
        int windowX = AquaVectorTabControlIcon.round((double)x);
        int windowY = AquaVectorTabControlIcon.round((double)y);
        Area ret = new Area(new Rectangle2D.Double(windowX, windowY, width, height));
        ret.subtract(new Area(new Rectangle2D.Double(windowX + borderThickness, windowY + titleBarHeight, width - borderThickness * 2, height - borderThickness - titleBarHeight)));
        if (this.buttonId == 12) {
            ret.add(new Area(new Rectangle2D.Double(windowX + borderThickness * 2, windowY + height - borderThickness * 4, AquaVectorTabControlIcon.round((double)((double)(width - borderThickness * 4) * 0.67)), borderThickness * 2)));
        } else if (this.buttonId == 2) {
            int marginX = AquaVectorTabControlIcon.round((double)((double)width * 0.3));
            int marginY = AquaVectorTabControlIcon.round((double)((double)height * 0.3));
            ret.add(new Area(new Rectangle2D.Double(windowX + marginX, windowY + marginY, width - marginX * 2, height - marginY * 2)));
        }
        return ret;
    }
}

