/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.scanner;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public class CountingVisitor
implements Visitor {
    private Map<Class<?>, Info> infoMap = new HashMap();
    private int count;
    private int size;

    @Override
    public void visitClass(Class<?> cls) {
        this.infoMap.put(cls, new Info());
    }

    @Override
    public void visitObject(ObjectMap map, Object obj) {
        Info info = this.infoMap.get(obj.getClass());
        assert (info != null) : "Engine shall announce the class before instance";
        ++info.count;
        ++this.count;
        int objSize = ScannerUtils.sizeOf(obj);
        info.size += objSize;
        this.size += objSize;
    }

    @Override
    public void visitStaticReference(ObjectMap map, Object to, Field ref) {
    }

    @Override
    public void visitObjectReference(ObjectMap map, Object from, Object to, Field ref) {
    }

    @Override
    public void visitArrayReference(ObjectMap map, Object from, Object to, int index) {
    }

    public Set<Class<?>> getClasses() {
        return Collections.unmodifiableSet(this.infoMap.keySet());
    }

    public int getCountForClass(Class cls) {
        Info info = this.infoMap.get(cls);
        if (info == null) {
            throw new IllegalArgumentException("Unknown class");
        }
        return info.count;
    }

    public int getSizeForClass(Class cls) {
        Info info = this.infoMap.get(cls);
        if (info == null) {
            throw new IllegalArgumentException("Unknown class");
        }
        return info.size;
    }

    public int getTotalCount() {
        return this.count;
    }

    public int getTotalSize() {
        return this.size;
    }

    private static class Info {
        int count;
        int size;

        private Info() {
        }
    }
}

