/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.output;

import java.awt.Color;
import javax.swing.Action;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public final class OutputVisitor {
    private OutputListener outputListener;
    private Action successAction;
    private boolean important;
    private String line;
    private boolean skipLine = false;
    private IOColors.OutputType outputType;
    private Color color;
    private Context context;
    public static final String ACTION_QUESTION = "Question";
    public static final String ACTION_PRIORITY = "Priority";

    public OutputVisitor() {
    }

    public OutputVisitor(Context context) {
        this.context = context;
    }

    public void resetVisitor() {
        this.outputListener = null;
        this.successAction = null;
        this.important = false;
        this.line = null;
        this.skipLine = false;
        this.color = null;
        this.outputType = null;
    }

    public OutputListener getOutputListener() {
        return this.outputListener;
    }

    public void setOutputListener(OutputListener listener) {
        this.outputListener = listener;
    }

    public void setOutputListener(OutputListener listener, boolean isImportant) {
        this.setOutputListener(listener);
        this.important = isImportant;
    }

    public boolean isImportant() {
        return this.important;
    }

    public Action getSuccessAction() {
        return this.successAction;
    }

    public void setSuccessAction(Action sAction) {
        this.successAction = sAction;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public void skipLine() {
        this.skipLine = true;
    }

    public boolean isLineSkipped() {
        return this.skipLine;
    }

    public Color getColor(InputOutput io) {
        Color c = this.outputType == null ? null : IOColors.getColor((InputOutput)io, (IOColors.OutputType)this.outputType);
        return c == null ? this.getColor() : c;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setOutputType(IOColors.OutputType outputType) {
        this.outputType = outputType;
    }

    @CheckForNull
    public Context getContext() {
        return this.context;
    }

    public static interface Context {
        @CheckForNull
        public Project getCurrentProject();
    }
}

