/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import java.io.IOException;
import java.io.OutputStream;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPFormatException;
import org.archive.util.ByteOp;

public class GZIPFooter
implements GZIPConstants {
    byte[] buffer = null;

    public GZIPFooter(byte[] buffer) throws GZIPFormatException {
        if (buffer.length != 8) {
            throw new GZIPFormatException("Wrong length footer");
        }
        this.buffer = buffer;
    }

    public GZIPFooter(long crc, long length) {
        this.buffer = new byte[8];
        ByteOp.writeInt(this.buffer, 0, crc);
        ByteOp.writeInt(this.buffer, 4, length);
    }

    public long getCRC() {
        return ByteOp.bytesToInt(this.buffer, 0);
    }

    public long getLength() {
        return ByteOp.bytesToInt(this.buffer, 4);
    }

    public void verify(long crc, long length) throws GZIPFormatException {
        int wantCRCi = (int)(crc & 0xFFFFFFFFFFFFFFFFL);
        if ((long)wantCRCi != this.getCRC()) {
            throw new GZIPFormatException("GZip crc error");
        }
        if (length != this.getLength()) {
            throw new GZIPFormatException("GZip length error");
        }
    }

    public void writeBytes(OutputStream os) throws IOException {
        os.write(this.buffer);
    }
}

