/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.archive.util.FileUtils;

public class ObjectPlusFilesOutputStream
extends ObjectOutputStream {
    protected LinkedList<File> auxiliaryDirectoryStack = new LinkedList();

    public ObjectPlusFilesOutputStream(OutputStream out, File topDirectory) throws IOException {
        super(out);
        this.auxiliaryDirectoryStack.addFirst(topDirectory);
    }

    public void pushAuxiliaryDirectory(String dir) {
        this.auxiliaryDirectoryStack.addFirst(new File(this.getAuxiliaryDirectory(), dir));
    }

    public void popAuxiliaryDirectory() {
        this.auxiliaryDirectoryStack.removeFirst();
    }

    public File getAuxiliaryDirectory() {
        return this.auxiliaryDirectoryStack.getFirst();
    }

    public void snapshotAppendOnlyFile(File file) throws IOException {
        String name = file.getName();
        this.writeUTF(name);
        this.writeLong(file.length());
        File auxDir = this.getAuxiliaryDirectory();
        if (!auxDir.exists()) {
            FileUtils.ensureWriteableDirectory(auxDir);
        }
        File destination = new File(auxDir, name);
        this.hardlinkOrCopy(file, destination);
    }

    private void hardlinkOrCopy(File file, File destination) throws IOException {
        Process link = Runtime.getRuntime().exec("ln " + file.getAbsolutePath() + " " + destination.getAbsolutePath());
        try {
            link.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (link.exitValue() != 0) {
            FileUtils.copyFile(file, destination);
        }
    }
}

