/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource;

import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class MetaData
extends JSONObject {
    private static final Logger LOG = Logger.getLogger(MetaData.class.getName());
    private MetaData topMetaData;

    public MetaData(MetaData parentMetaData, String name) {
        this.topMetaData = parentMetaData == null ? this : parentMetaData.topMetaData;
        parentMetaData.putChild(name, this);
    }

    public MetaData(String jsonString) throws JSONException {
        super(jsonString);
        this.topMetaData = this;
    }

    public MetaData(JSONTokener jsonTokener) throws JSONException {
        super(jsonTokener);
        this.topMetaData = this;
    }

    public MetaData() {
        this.topMetaData = this;
    }

    public Object get(String key) {
        try {
            return super.get(key);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public boolean getBoolean(String key) {
        try {
            return super.getBoolean(key);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return false;
        }
    }

    public int getInt(String key) {
        try {
            return super.getInt(key);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return -1;
        }
    }

    public long getLong(String key) {
        try {
            return super.getLong(key);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return -1L;
        }
    }

    public String getString(String key) {
        try {
            return super.getString(key);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public MetaData createChild(String name) {
        return new MetaData(this, name);
    }

    public MetaData getTopMetaData() {
        if (this.topMetaData == null) {
            return this;
        }
        return this.topMetaData;
    }

    public void setTopMetaData(MetaData topMetaData) {
        this.topMetaData = topMetaData;
    }

    public JSONObject putString(String key, String val) {
        try {
            return super.put(key, (Object)val);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public JSONObject putLong(String key, long val) {
        try {
            return super.put(key, (Object)String.valueOf(val));
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public JSONObject putBoolean(String key, boolean val) {
        try {
            return super.put(key, val);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public JSONObject putChild(String key, JSONObject child) {
        try {
            return super.put(key, (Object)child);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public JSONObject appendChild(String key, JSONObject child) {
        try {
            JSONArray jarr = this.optJSONArray(key);
            if (jarr == null) {
                Object ob = this.remove(key);
                if (ob != null) {
                    LOG.warning("Removed(" + key + ") containing:" + ob.toString());
                }
                jarr = new JSONArray();
                jarr.put((Object)child);
                this.put(key, jarr);
            } else {
                jarr.put((Object)child);
            }
            return this;
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public void appendObj(String key, String ... a) {
        JSONObject n = new JSONObject();
        if ((a.length & 1) == 1) {
            throw new IllegalArgumentException();
        }
        try {
            for (int i = 0; i < a.length; i += 2) {
                n.put(a[i], (Object)a[i + 1]);
            }
            this.appendChild(key, n);
        }
        catch (JSONException e) {
            LOG.severe(e.getMessage());
        }
    }
}

