/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.archive.url.LaxURLCodec;

public class LaxURI
extends URI {
    private static final long serialVersionUID = 5273922211722239537L;
    protected static final char[] HTTP_SCHEME = new char[]{'h', 't', 't', 'p'};
    protected static final char[] HTTPS_SCHEME = new char[]{'h', 't', 't', 'p', 's'};
    protected static final BitSet lax_rel_segment = new BitSet(256);
    protected static final BitSet lax_abs_path;
    protected static final BitSet lax_rel_path;
    protected static final BitSet lax_query;

    public LaxURI(String uri, boolean escaped, String charset) throws URIException {
        super(uri, escaped, charset);
    }

    public LaxURI(URI base, URI relative) throws URIException {
        super(base, relative);
    }

    public LaxURI(String uri, boolean escaped) throws URIException {
        super(uri, escaped);
    }

    public LaxURI() {
    }

    public String getURI() throws URIException {
        return this._uri == null ? null : LaxURI.decode(this._uri, this.getProtocolCharset());
    }

    public String getPath() throws URIException {
        char[] p = this.getRawPath();
        return p == null ? null : LaxURI.decode(p, this.getProtocolCharset());
    }

    public String getPathQuery() throws URIException {
        char[] rawPathQuery = this.getRawPathQuery();
        return rawPathQuery == null ? null : LaxURI.decode(rawPathQuery, this.getProtocolCharset());
    }

    protected static String decode(char[] component, String charset) throws URIException {
        if (component == null) {
            throw new IllegalArgumentException("Component array of chars may not be null");
        }
        return LaxURI.decode(new String(component), charset);
    }

    protected static String decode(String component, String charset) throws URIException {
        if (component == null) {
            throw new IllegalArgumentException("Component array of chars may not be null");
        }
        byte[] rawdata = null;
        rawdata = LaxURLCodec.decodeUrlLoose(EncodingUtil.getAsciiBytes((String)component));
        return EncodingUtil.getString((byte[])rawdata, (String)charset);
    }

    protected boolean validate(char[] component, BitSet generous) {
        return super.validate(component, this.lax(generous));
    }

    protected boolean validate(char[] component, int soffset, int eoffset, BitSet generous) {
        return super.validate(component, soffset, eoffset, this.lax(generous));
    }

    protected BitSet lax(BitSet generous) {
        if (generous == rel_segment) {
            return lax_rel_segment;
        }
        if (generous == abs_path) {
            return lax_abs_path;
        }
        if (generous == query) {
            return lax_query;
        }
        if (generous == rel_path) {
            return lax_rel_path;
        }
        return generous;
    }

    protected void parseAuthority(String original, boolean escaped) throws URIException {
        super.parseAuthority(original, escaped);
        if (this._host != null && this._authority != null && this._host.length == this._authority.length) {
            this._host = this._authority;
        }
    }

    protected void setURI() {
        if (this._scheme != null) {
            if (this._scheme.length == 4 && Arrays.equals(this._scheme, HTTP_SCHEME)) {
                this._scheme = HTTP_SCHEME;
            } else if (this._scheme.length == 5 && Arrays.equals(this._scheme, HTTPS_SCHEME)) {
                this._scheme = HTTPS_SCHEME;
            }
        }
        super.setURI();
    }

    protected void parseUriReference(String original, boolean escaped) throws URIException {
        char[] target;
        int at;
        char[] lastDelimiter;
        char[] firstDelimiter;
        if (original == null) {
            throw new URIException("URI-Reference required");
        }
        String tmp = original.trim();
        int length = tmp.length();
        if (length > 0 && this.validate(firstDelimiter = new char[]{tmp.charAt(0)}, delims) && length >= 2 && this.validate(lastDelimiter = new char[]{tmp.charAt(length - 1)}, delims)) {
            tmp = tmp.substring(1, length - 1);
            length -= 2;
        }
        int from = 0;
        boolean isStartedFromPath = false;
        int atColon = tmp.indexOf(58);
        int atSlash = tmp.indexOf(47);
        if (!tmp.startsWith("//") && (atColon <= 0 || atSlash >= 0 && atSlash < atColon)) {
            isStartedFromPath = true;
        }
        if ((at = this.indexFirstOf(tmp, isStartedFromPath ? "/?#" : ":/?#", from)) == -1) {
            at = 0;
        }
        if (at > 0 && at < length && tmp.charAt(at) == ':' && this.validate(target = tmp.substring(0, at).toLowerCase().toCharArray(), scheme)) {
            this._scheme = target;
            from = ++at;
        }
        this._is_hier_part = false;
        this._is_rel_path = false;
        this._is_abs_path = false;
        this._is_net_path = false;
        if (0 <= at && at < length && tmp.charAt(at) == '/') {
            this._is_hier_part = true;
            if (at + 2 < length && tmp.charAt(at + 1) == '/' && !isStartedFromPath) {
                int next = this.indexFirstOf(tmp, "/?#", at + 2);
                if (next == -1) {
                    next = tmp.substring(at + 2).length() == 0 ? at + 2 : tmp.length();
                }
                this.parseAuthority(tmp.substring(at + 2, next), escaped);
                from = at = next;
                this._is_net_path = true;
            }
            if (from == at) {
                this._is_abs_path = true;
            }
        }
        if (from < length) {
            int next = this.indexFirstOf(tmp, "?#", from);
            if (next == -1) {
                next = tmp.length();
            }
            if (!this._is_abs_path) {
                if (!escaped && this.prevalidate(tmp.substring(from, next), disallowed_rel_path) || escaped && this.validate(tmp.substring(from, next).toCharArray(), rel_path)) {
                    this._is_rel_path = true;
                } else if (!escaped && this.prevalidate(tmp.substring(from, next), disallowed_opaque_part) || escaped && this.validate(tmp.substring(from, next).toCharArray(), opaque_part)) {
                    this._is_opaque_part = true;
                } else {
                    this._path = null;
                }
            }
            String s = tmp.substring(from, next);
            if (escaped) {
                this.setRawPath(s.toCharArray());
            } else {
                this.setPath(s);
            }
            at = next;
        }
        String charset = this.getProtocolCharset();
        if (0 <= at && at + 1 < length && tmp.charAt(at) == '?') {
            int next = tmp.indexOf(35, at + 1);
            if (next == -1) {
                next = tmp.length();
            }
            if (escaped) {
                this._query = tmp.substring(at + 1, next).toCharArray();
                if (!this.validate(this._query, query)) {
                    throw new URIException("Invalid query");
                }
            } else {
                this._query = LaxURI.encode((String)tmp.substring(at + 1, next), (BitSet)allowed_query, (String)charset);
            }
            at = next;
        }
        if (0 <= at && at + 1 <= length && tmp.charAt(at) == '#') {
            this._fragment = at + 1 == length ? "".toCharArray() : (escaped ? tmp.substring(at + 1).toCharArray() : LaxURI.encode((String)tmp.substring(at + 1), (BitSet)allowed_fragment, (String)charset));
        }
        this.setURI();
    }

    static {
        lax_rel_segment.or(rel_segment);
        lax_rel_segment.set(58);
        lax_abs_path = new BitSet(256);
        lax_abs_path.or(abs_path);
        lax_abs_path.set(124);
        lax_rel_path = new BitSet(256);
        lax_rel_path.or(lax_rel_segment);
        lax_rel_path.or(lax_abs_path);
        lax_query = new BitSet(256);
        lax_query.or(query);
        lax_query.set(123);
        lax_query.set(125);
        lax_query.set(124);
        lax_query.set(91);
        lax_query.set(93);
        lax_query.set(94);
    }
}

