/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch;

import java.io.IOException;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.util.GeneralURIStreamFactory;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SeekableLineReaderFactory;
import org.archive.util.binsearch.SeekableLineReaderIterator;
import org.archive.util.iterator.CloseableIterator;

public class SortedTextFile {
    public static final Comparator<String> numericComparator = new NumericComparator();
    public static final Comparator<String> defaultComparator = new DefaultComparator();
    private static final Logger LOGGER = Logger.getLogger(SortedTextFile.class.getName());
    protected SeekableLineReaderFactory factory;
    protected int binsearchBlockSize = 8192;

    public SortedTextFile(SeekableLineReaderFactory factory) {
        this.setFactory(factory);
    }

    public SortedTextFile(String filename) throws IOException {
        this(filename, true);
    }

    public SortedTextFile(String filename, boolean useNio) throws IOException {
        this.factory = GeneralURIStreamFactory.createSeekableStreamFactory(filename, useNio);
    }

    protected SortedTextFile() {
        this.factory = null;
    }

    protected void setFactory(SeekableLineReaderFactory factory) {
        this.factory = factory;
    }

    public void reloadFactory() {
        try {
            this.factory.reload();
        }
        catch (IOException e) {
            LOGGER.warning(e.toString());
        }
    }

    public int getBinsearchBlockSize() {
        return this.binsearchBlockSize;
    }

    public void setBinsearchBlockSize(int binsearchBlockSize) {
        this.binsearchBlockSize = binsearchBlockSize;
    }

    public CloseableIterator<String> getRecordIteratorLT(String prefix) throws IOException {
        return this.getRecordIterator(prefix, true);
    }

    public CloseableIterator<String> getRecordIterator(String prefix) throws IOException {
        return this.getRecordIterator(prefix, false);
    }

    public SeekableLineReader getSLR() throws IOException {
        return this.factory.get();
    }

    public CloseableIterator<String> getRecordIterator(long offset) throws IOException {
        SeekableLineReader slr = this.factory.get();
        slr.seek(offset);
        return new SeekableLineReaderIterator(slr);
    }

    public CloseableIterator<String> getRecordIterator(String prefix, boolean lessThan) throws IOException {
        SeekableLineReader slr = this.factory.get();
        try {
            return this.search(slr, prefix, lessThan, defaultComparator);
        }
        catch (IOException io) {
            if (slr != null) {
                slr.close();
            }
            throw io;
        }
    }

    public long binaryFindOffset(SeekableLineReader slr, String key, Comparator<String> comparator) throws IOException {
        int blockSize = this.binsearchBlockSize;
        long fileSize = slr.getSize();
        long min = 0L;
        long max = fileSize / (long)blockSize;
        while (max - min > 1L) {
            String line;
            long mid = min + (max - min) / 2L;
            slr.seek(mid * (long)blockSize);
            if (mid > 0L) {
                slr.skipLine();
            }
            if (comparator.compare(key, line = slr.readLine()) > 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("Search(%d) (%s)/(%s) : After", mid * (long)blockSize, key, line));
                }
                min = mid;
                continue;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Search(%d) (%s)/(%s) : Before", mid * (long)blockSize, key, line));
            }
            max = mid;
        }
        return min *= (long)blockSize;
    }

    public long[] getStartEndOffsets(SeekableLineReader slr, String start, String end) throws IOException {
        long endOffset = 0L;
        endOffset = end != null && !end.isEmpty() ? this.searchOffset(slr, end, false, defaultComparator) : slr.getSize();
        long startOffset = 0L;
        if (start != null && !start.isEmpty()) {
            startOffset = this.searchOffset(slr, start, true, defaultComparator);
        }
        return new long[]{startOffset, endOffset};
    }

    public CloseableIterator<String> getSplitIterator(String start, String end, int numSplits) throws IOException {
        SeekableLineReader slr = this.factory.get();
        long[] offsets = this.getStartEndOffsets(slr, start, end);
        return new StepSeekingIterator(slr, offsets[0], offsets[1], numSplits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRange(String start, String end) throws IOException {
        SeekableLineReader slr = null;
        String startLine = null;
        String endLine = null;
        try {
            slr = this.factory.get();
            if (start.isEmpty()) {
                slr.seek(0L);
                startLine = slr.readLine();
            } else {
                startLine = (String)this.search(slr, start, true, defaultComparator).next();
            }
            endLine = end.isEmpty() ? this.getLastLine(slr) : (String)this.search(slr, end, true, defaultComparator).next();
        }
        finally {
            if (slr != null) {
                slr.close();
            }
        }
        return new String[]{startLine, endLine};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNthSplit(String start, String end, int split, int numSplits) throws IOException {
        SeekableLineReader slr = null;
        String startLine = null;
        String endLine = null;
        try {
            slr = this.factory.get();
            long[] offsets = this.getStartEndOffsets(slr, start, end);
            long startOffset = offsets[0];
            long diff = offsets[1] - offsets[0];
            long seekDiff = diff * (long)split / (long)numSplits;
            slr.seek(startOffset + seekDiff);
            if (startOffset + seekDiff > 0L) {
                slr.skipLine();
            }
            startLine = slr.readLine();
            endLine = null;
            if (split <= numSplits - 1) {
                seekDiff = diff * (long)(split + 1) / (long)numSplits;
                slr.seek(startOffset + seekDiff);
                slr.skipLine();
                endLine = slr.readLine();
            } else {
                endLine = end;
            }
            if (endLine == null) {
                endLine = this.getLastLine(slr);
            }
        }
        finally {
            if (slr != null) {
                slr.close();
            }
        }
        return new String[]{startLine, endLine};
    }

    public String getLastLine(SeekableLineReader slr) throws IOException {
        int lastLineLenTest = 0;
        int lastLineLenInc = 400;
        String endLine = null;
        do {
            slr.seek(slr.getSize() - (long)(lastLineLenTest += lastLineLenInc));
            slr.readLine();
            String nextLine = null;
            endLine = null;
            while ((nextLine = slr.readLine()) != null) {
                endLine = nextLine;
            }
        } while (endLine == null);
        return endLine;
    }

    private long searchOffset(SeekableLineReader slr, String key, boolean lessThan, Comparator<String> comparator) throws IOException {
        long offset = this.binaryFindOffset(slr, key, comparator);
        slr.seek(offset);
        String line = null;
        if (offset > 0L) {
            slr.skipLine();
        }
        String prev = null;
        while (true) {
            if (line != null) {
                offset += (long)(line.getBytes().length + 1);
            }
            if ((line = slr.readLine()) == null || comparator.compare(line, key) >= 0) break;
            prev = line;
        }
        if (lessThan && prev != null) {
            offset -= (long)(prev.getBytes().length + 1);
        }
        return offset;
    }

    private CloseableIterator<String> search(SeekableLineReader slr, String key, boolean lessThan, Comparator<String> comparator) throws IOException {
        String line;
        long min = this.binaryFindOffset(slr, key, comparator);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Aligning(%d)", min));
        }
        slr.seek(min);
        if (min > 0L) {
            slr.skipLine();
        }
        String prev = null;
        while ((line = slr.readLine()) != null && comparator.compare(line, key) < 0) {
            prev = line;
        }
        if (!lessThan) {
            prev = null;
        }
        return new CachedStringIterator(slr, prev, line);
    }

    public static class CachedStringIterator
    implements CloseableIterator<String> {
        private String first;
        private String second;
        private SeekableLineReader slr;
        private SeekableLineReaderIterator it;

        public CachedStringIterator(String first, String second) {
            this.slr = null;
            this.first = first;
            this.second = second;
        }

        public CachedStringIterator(SeekableLineReader slr, String first, String second) {
            this.slr = slr;
            this.first = first;
            this.second = second;
            if (slr != null) {
                this.it = new SeekableLineReaderIterator(slr);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.first != null) {
                return true;
            }
            if (this.second != null) {
                return true;
            }
            if (this.it == null) {
                return false;
            }
            return this.it.hasNext();
        }

        @Override
        public String next() {
            if (this.first != null) {
                String tmp = this.first;
                this.first = null;
                return tmp;
            }
            if (this.second != null) {
                String tmp = this.second;
                this.second = null;
                return tmp;
            }
            if (this.it == null) {
                return null;
            }
            return (String)this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            if (this.slr != null) {
                this.slr.close();
            }
        }
    }

    class StepSeekingIterator
    implements CloseableIterator<String> {
        long startOffset;
        int numSplits;
        long endOffset;
        int currSplit;
        SeekableLineReader slr;

        public StepSeekingIterator(SeekableLineReader slr, long startOffset, long endOffset, int numSplits) throws IOException {
            this.slr = slr;
            this.currSplit = 0;
            this.startOffset = startOffset;
            this.numSplits = numSplits;
            this.endOffset = endOffset;
            slr.seek(startOffset);
        }

        @Override
        public boolean hasNext() {
            return this.currSplit < this.numSplits;
        }

        @Override
        public String next() {
            String line = null;
            try {
                if (this.startOffset + (long)this.currSplit != 0L) {
                    this.slr.skipLine();
                }
                line = this.slr.readLine();
                ++this.currSplit;
                long seekDiff = (this.endOffset - this.startOffset) * (long)this.currSplit / (long)this.numSplits;
                this.slr.seek(this.startOffset + seekDiff);
            }
            catch (IOException io) {
                io.printStackTrace();
            }
            return line;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.slr.close();
        }
    }

    public static class DefaultComparator
    implements Comparator<String> {
        @Override
        public int compare(String arg0, String arg1) {
            return arg0.compareTo(arg1);
        }
    }

    public static class NumericComparator
    implements Comparator<String> {
        @Override
        public int compare(String arg0, String arg1) {
            long val1;
            long val0 = Long.parseLong(arg0);
            if (val0 < (val1 = Long.parseLong(arg1))) {
                return -1;
            }
            if (val0 == val1) {
                return 0;
            }
            return 1;
        }
    }
}

