/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.archive.io.Preformatter;
import org.archive.util.FileUtils;

public class GenerationFileHandler
extends FileHandler {
    private LinkedList<String> filenameSeries = new LinkedList();
    private boolean shouldManifest = false;

    public List<String> getFilenameSeries() {
        return this.filenameSeries;
    }

    public GenerationFileHandler(String pattern, boolean append, boolean shouldManifest) throws IOException, SecurityException {
        super(pattern, append);
        this.filenameSeries.addFirst(pattern);
        this.shouldManifest = shouldManifest;
    }

    public GenerationFileHandler(LinkedList<String> filenameSeries, boolean shouldManifest) throws IOException {
        super(filenameSeries.getFirst(), false);
        this.filenameSeries = filenameSeries;
        this.shouldManifest = shouldManifest;
    }

    public GenerationFileHandler rotate(String storeSuffix, String activeSuffix) throws IOException {
        return this.rotate(storeSuffix, activeSuffix, false);
    }

    public GenerationFileHandler rotate(String storeSuffix, String activeSuffix, boolean mergeOld) throws IOException {
        this.close();
        String filename = this.filenameSeries.getFirst();
        if (!filename.endsWith(activeSuffix)) {
            throw new FileNotFoundException("Active file does not have expected suffix");
        }
        String storeFilename = filename.substring(0, filename.length() - activeSuffix.length()) + storeSuffix;
        File activeFile = new File(filename);
        File storeFile = new File(storeFilename);
        FileUtils.moveAsideIfExists(storeFile);
        if (mergeOld) {
            File fileToAppendTo = new File(this.filenameSeries.getLast());
            for (int i = this.filenameSeries.size() - 2; i >= 0; --i) {
                File f = new File(this.filenameSeries.get(i));
                FileUtils.appendTo(fileToAppendTo, f);
                f.delete();
            }
            this.filenameSeries.clear();
            this.filenameSeries.add(filename);
            if (!fileToAppendTo.renameTo(storeFile)) {
                throw new IOException("Unable to move " + fileToAppendTo + " to " + storeFilename);
            }
        } else if (!activeFile.renameTo(storeFile)) {
            throw new IOException("Unable to move " + filename + " to " + storeFilename);
        }
        this.filenameSeries.add(1, storeFilename);
        GenerationFileHandler newGfh = new GenerationFileHandler(this.filenameSeries, this.shouldManifest);
        newGfh.setFormatter(this.getFormatter());
        return newGfh;
    }

    public boolean shouldManifest() {
        return this.shouldManifest;
    }

    public static GenerationFileHandler makeNew(String filename, boolean append, boolean shouldManifest) throws SecurityException, IOException {
        FileUtils.moveAsideIfExists(new File(filename));
        return new GenerationFileHandler(filename, append, shouldManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        Formatter f = this.getFormatter();
        if (!(f instanceof Preformatter)) {
            super.publish(record);
        } else {
            try {
                ((Preformatter)((Object)f)).preformat(record);
                super.publish(record);
            }
            finally {
                ((Preformatter)((Object)f)).clear();
            }
        }
    }
}

