/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.archive.io.RecorderLengthExceededException;
import org.archive.io.RecorderTimeoutException;
import org.archive.io.RecordingOutputStream;
import org.archive.io.ReplayInputStream;

public class RecordingInputStream
extends InputStream {
    protected static Logger logger = Logger.getLogger("org.archive.io.RecordingInputStream");
    private RecordingOutputStream recordingOutputStream;
    private InputStream in = null;
    protected byte[] drainBuffer = new byte[16384];

    public RecordingInputStream(int bufferSize, String backingFilename) {
        this.recordingOutputStream = new RecordingOutputStream(bufferSize, backingFilename);
    }

    public void open(InputStream wrappedStream) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("wrapping " + wrappedStream + " in thread " + Thread.currentThread().getName());
        }
        if (this.isOpen()) {
            throw new IOException("RIS already open for " + Thread.currentThread().getName());
        }
        try {
            this.in = wrappedStream;
            this.recordingOutputStream.open();
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
    }

    @Override
    public int read() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Stream closed " + Thread.currentThread().getName());
        }
        int b = this.in.read();
        if (b != -1) {
            assert (this.recordingOutputStream != null) : "ROS is null " + Thread.currentThread().getName();
            this.recordingOutputStream.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Stream closed " + Thread.currentThread().getName());
        }
        int count = this.in.read(b, off, len);
        if (count > 0) {
            assert (this.recordingOutputStream != null) : "ROS is null " + Thread.currentThread().getName();
            this.recordingOutputStream.write(b, off, count);
        }
        return count;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Stream closed " + Thread.currentThread().getName());
        }
        int count = this.in.read(b);
        if (count > 0) {
            assert (this.recordingOutputStream != null) : "ROS is null " + Thread.currentThread().getName();
            this.recordingOutputStream.write(b, 0, count);
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("closing " + this.in + " in thread " + Thread.currentThread().getName());
        }
        IOUtils.closeQuietly((InputStream)this.in);
        this.in = null;
        IOUtils.closeQuietly((OutputStream)this.recordingOutputStream);
    }

    public ReplayInputStream getReplayInputStream() throws IOException {
        return this.recordingOutputStream.getReplayInputStream();
    }

    public ReplayInputStream getMessageBodyReplayInputStream() throws IOException {
        return this.recordingOutputStream.getMessageBodyReplayInputStream();
    }

    public long readFully() throws IOException {
        while (this.read(this.drainBuffer) != -1) {
        }
        return this.recordingOutputStream.getSize();
    }

    public void readToEndOfContent(long contentLength) throws IOException, InterruptedException {
        if (!this.isOpen()) {
            return;
        }
        long totalBytes = this.recordingOutputStream.position - this.recordingOutputStream.getMessageBodyBegin();
        long bytesRead = -1L;
        long maxToRead = -1L;
        while (contentLength <= 0L || totalBytes < contentLength) {
            try {
                maxToRead = contentLength <= 0L ? (long)this.drainBuffer.length : Math.min((long)this.drainBuffer.length, contentLength - totalBytes);
                maxToRead = Math.min(maxToRead, this.recordingOutputStream.getRemainingLength());
                maxToRead = Math.max(maxToRead, 1L);
                bytesRead = this.read(this.drainBuffer, 0, (int)maxToRead);
                if (bytesRead != -1L) {
                    totalBytes += bytesRead;
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Interrupted during IO");
                }
                break;
            }
            catch (SocketTimeoutException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "socket timeout", e);
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException("Interrupted during IO");
                }
                this.recordingOutputStream.checkLimits();
            }
            catch (SocketException se) {
                throw se;
            }
            catch (NullPointerException e) {
                throw new NullPointerException("Stream " + this.in + ", " + e.getMessage() + " " + Thread.currentThread().getName());
            }
        }
    }

    public void readFullyOrUntil(long softMaxLength) throws IOException, RecorderLengthExceededException, RecorderTimeoutException, InterruptedException {
        if (!this.isOpen()) {
            return;
        }
        long totalBytes = 0L;
        long bytesRead = -1L;
        long maxToRead = -1L;
        do {
            try {
                maxToRead = softMaxLength <= 0L ? (long)this.drainBuffer.length : Math.min((long)this.drainBuffer.length, softMaxLength - totalBytes);
                maxToRead = Math.min(maxToRead, this.recordingOutputStream.getRemainingLength());
                maxToRead = Math.max(maxToRead, 1L);
                bytesRead = this.read(this.drainBuffer, 0, (int)maxToRead);
                if (bytesRead != -1L) {
                    totalBytes += bytesRead;
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Interrupted during IO");
                }
                break;
            }
            catch (SocketTimeoutException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "socket timeout", e);
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException("Interrupted during IO");
                }
                this.recordingOutputStream.checkLimits();
            }
            catch (SocketException se) {
                throw se;
            }
            catch (NullPointerException e) {
                throw new NullPointerException("Stream " + this.in + ", " + e.getMessage() + " " + Thread.currentThread().getName());
            }
        } while (softMaxLength <= 0L || totalBytes < softMaxLength);
    }

    public long getSize() {
        return this.recordingOutputStream.getSize();
    }

    public void markContentBegin() {
        this.recordingOutputStream.markMessageBodyBegin();
    }

    public long getContentBegin() {
        return this.recordingOutputStream.getMessageBodyBegin();
    }

    public void startDigest() {
        this.recordingOutputStream.startDigest();
    }

    public void setSha1Digest() {
        this.recordingOutputStream.setSha1Digest();
    }

    public void setDigest(String algorithm) {
        this.recordingOutputStream.setDigest(algorithm);
    }

    public void setDigest(MessageDigest md) {
        this.recordingOutputStream.setDigest(md);
    }

    public byte[] getDigestValue() {
        return this.recordingOutputStream.getDigestValue();
    }

    public long getResponseContentLength() {
        return this.recordingOutputStream.getResponseContentLength();
    }

    public void closeRecorder() throws IOException {
        this.recordingOutputStream.closeRecorder();
    }

    public boolean isOpen() {
        return this.in != null;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.recordingOutputStream.mark();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.recordingOutputStream.reset();
    }

    public void setLimits(long hardMax, long timeoutMs, long maxRateKBps) {
        this.recordingOutputStream.setLimits(hardMax, timeoutMs, maxRateKBps);
    }

    public int getRecordedBufferLength() {
        return this.recordingOutputStream.getBufferLength();
    }

    public void chopAtMessageBodyBegin() {
        this.recordingOutputStream.chopAtMessageBodyBegin();
    }

    public void clearForReuse() throws IOException {
        this.recordingOutputStream.clearForReuse();
    }
}

