/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.RecorderIOException;
import org.archive.io.RecorderLengthExceededException;
import org.archive.io.RecorderTimeoutException;
import org.archive.io.RecorderTooMuchHeaderException;
import org.archive.io.ReplayInputStream;

public class RecordingOutputStream
extends OutputStream {
    protected static Logger logger = Logger.getLogger(RecordingOutputStream.class.getName());
    protected long size = 0L;
    protected String backingFilename;
    protected OutputStream diskStream = null;
    private byte[] buffer;
    long position;
    private boolean recording;
    private boolean shouldDigest = false;
    private MessageDigest digest = null;
    private static final String SHA1 = "SHA1";
    protected static final long MAX_HEADER_MATERIAL = 0x100000L;
    protected long maxLength = Long.MAX_VALUE;
    protected long timeoutMs = Long.MAX_VALUE;
    protected long maxRateBytesPerMs = Long.MAX_VALUE;
    protected long startTime = Long.MAX_VALUE;
    protected long messageBodyBeginMark;
    protected int[] lastTwoBytes = new int[]{-1, -1};
    private OutputStream out = null;
    private long maxPosition = 0L;
    private long markPosition = 0L;

    public RecordingOutputStream(int bufferSize, String backingFilename) {
        this.buffer = new byte[bufferSize];
        this.backingFilename = backingFilename;
        this.recording = true;
    }

    public void open() throws IOException {
        this.open(null);
    }

    public void open(OutputStream wrappedStream) throws IOException {
        if (this.isOpen()) {
            throw new IOException("ROS already open for " + Thread.currentThread().getName());
        }
        this.clearForReuse();
        this.out = wrappedStream;
        this.startTime = System.currentTimeMillis();
    }

    protected OutputStream ensureDiskStream() throws FileNotFoundException {
        if (this.diskStream == null) {
            FileOutputStream fis = new FileOutputStream(this.backingFilename);
            this.diskStream = new FastBufferedOutputStream((OutputStream)fis);
        }
        return this.diskStream;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.position < this.maxPosition) {
            ++this.position;
            return;
        }
        if (this.recording) {
            this.record(b);
        }
        if (this.out != null) {
            this.out.write(b);
        }
        if (this.messageBodyBeginMark < 0L) {
            if (b == 10 && (this.lastTwoBytes[1] == 10 || this.lastTwoBytes[0] == 10 && this.lastTwoBytes[1] == 13)) {
                this.markMessageBodyBegin();
            } else {
                this.lastTwoBytes[0] = this.lastTwoBytes[1];
                this.lastTwoBytes[1] = b;
            }
        }
        this.checkLimits();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.position < this.maxPosition) {
            if (this.position + (long)len <= this.maxPosition) {
                this.position += (long)len;
                return;
            }
            long consumeRange = this.maxPosition - this.position;
            this.position += consumeRange;
            off = (int)((long)off + consumeRange);
            len = (int)((long)len - consumeRange);
        }
        while (this.messageBodyBeginMark < 0L && len > 0) {
            this.write(b[off]);
            ++off;
            --len;
        }
        if (this.recording) {
            this.record(b, off, len);
        }
        if (this.out != null) {
            this.out.write(b, off, len);
        }
        this.checkLimits();
    }

    protected void checkLimits() throws RecorderIOException {
        if (this.messageBodyBeginMark < 0L && this.position > 0x100000L) {
            throw new RecorderTooMuchHeaderException();
        }
        if (this.position > this.maxLength) {
            throw new RecorderLengthExceededException();
        }
        long duration = System.currentTimeMillis() - this.startTime;
        if ((duration = Math.max(duration, 1L)) > this.timeoutMs) {
            throw new RecorderTimeoutException();
        }
        if (this.position / duration >= this.maxRateBytesPerMs) {
            long desiredDuration = this.position / this.maxRateBytesPerMs;
            try {
                Thread.sleep(desiredDuration - duration);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "bandwidth throttling sleep interrupted", e);
            }
        }
    }

    private void record(int b) throws IOException {
        if (this.shouldDigest) {
            this.digest.update((byte)b);
        }
        if (this.position >= (long)this.buffer.length) {
            this.ensureDiskStream().write(b);
        } else {
            this.buffer[(int)this.position] = (byte)b;
        }
        ++this.position;
    }

    private void record(byte[] b, int off, int len) throws IOException {
        if (this.shouldDigest) {
            assert (this.digest != null) : "Digest is null.";
            this.digest.update(b, off, len);
        }
        this.tailRecord(b, off, len);
    }

    private void tailRecord(byte[] b, int off, int len) throws IOException {
        if (this.position >= (long)this.buffer.length) {
            this.ensureDiskStream().write(b, off, len);
            this.position += (long)len;
        } else {
            assert (this.buffer != null) : "Buffer is null";
            int toCopy = (int)Math.min((long)this.buffer.length - this.position, (long)len);
            assert (b != null) : "Passed buffer is null";
            System.arraycopy(b, off, this.buffer, (int)this.position, toCopy);
            this.position += (long)toCopy;
            if (toCopy < len) {
                this.tailRecord(b, off + toCopy, len - toCopy);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.messageBodyBeginMark < 0L) {
            this.messageBodyBeginMark = 0L;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        this.closeRecorder();
    }

    protected synchronized void closeDiskStream() throws IOException {
        if (this.diskStream != null) {
            this.diskStream.close();
            this.diskStream = null;
        }
    }

    public void closeRecorder() throws IOException {
        this.recording = false;
        this.closeDiskStream();
        if (this.size == 0L) {
            this.size = this.position;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.diskStream != null) {
            this.diskStream.flush();
        }
    }

    public ReplayInputStream getReplayInputStream() throws IOException {
        return this.getReplayInputStream(0L);
    }

    public ReplayInputStream getReplayInputStream(long skip) throws IOException {
        assert (this.out == null) : "Stream is still open.";
        ReplayInputStream replay = new ReplayInputStream(this.buffer, this.size, this.messageBodyBeginMark, this.backingFilename);
        replay.skip(skip);
        return replay;
    }

    public ReplayInputStream getMessageBodyReplayInputStream() throws IOException {
        return this.getReplayInputStream(this.messageBodyBeginMark);
    }

    public long getSize() {
        return this.size;
    }

    public void markMessageBodyBegin() {
        this.messageBodyBeginMark = this.position;
        this.startDigest();
    }

    public long getMessageBodyBegin() {
        return this.messageBodyBeginMark;
    }

    public void startDigest() {
        if (this.digest != null) {
            this.digest.reset();
            this.shouldDigest = true;
        }
    }

    public void setSha1Digest() {
        this.setDigest(SHA1);
    }

    public void setDigest(String algorithm) {
        try {
            if (this.digest == null || !this.digest.getAlgorithm().equals(algorithm)) {
                this.setDigest(MessageDigest.getInstance(algorithm));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void setDigest(MessageDigest md) {
        this.digest = md;
    }

    public byte[] getDigestValue() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.digest();
    }

    public long getResponseContentLength() {
        return this.size - this.messageBodyBeginMark;
    }

    public boolean isOpen() {
        return this.out != null;
    }

    public int getBufferLength() {
        return this.buffer.length;
    }

    public void mark() {
        this.markPosition = this.position;
    }

    public void reset() {
        this.maxPosition = Math.max(this.maxPosition, this.position);
        this.position = this.markPosition;
    }

    public void setLimits(long length, long milliseconds, long rateKBps) {
        this.maxLength = length > 0L ? length : Long.MAX_VALUE;
        this.timeoutMs = milliseconds > 0L ? milliseconds : Long.MAX_VALUE;
        this.maxRateBytesPerMs = rateKBps > 0L ? rateKBps * 1024L / 1000L : Long.MAX_VALUE;
    }

    public void resetLimits() {
        this.maxLength = Long.MAX_VALUE;
        this.timeoutMs = Long.MAX_VALUE;
        this.maxRateBytesPerMs = Long.MAX_VALUE;
    }

    public long getRemainingLength() {
        return this.maxLength - this.position;
    }

    public void chopAtMessageBodyBegin() {
        if (this.messageBodyBeginMark >= 0L) {
            this.size = this.messageBodyBeginMark;
            this.position = this.messageBodyBeginMark;
        }
    }

    public void clearForReuse() throws IOException {
        this.out = null;
        this.position = 0L;
        this.markPosition = 0L;
        this.maxPosition = 0L;
        this.size = 0L;
        this.messageBodyBeginMark = -1L;
        this.recording = true;
        this.shouldDigest = false;
        if (this.diskStream != null) {
            this.closeDiskStream();
        }
    }
}

