/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RepositionableInputStream
extends BufferedInputStream
implements RepositionableStream {
    private long position = 0L;
    private long markPosition = -1L;

    public RepositionableInputStream(InputStream in) {
        super(in);
    }

    public RepositionableInputStream(InputStream in, int size) {
        super(in, size);
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        if (read != -1) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public synchronized int read(byte[] b, int offset, int ct) throws IOException {
        int read;
        if (!this.isMarked()) {
            super.mark(ct > offset ? ct - offset : ct);
        }
        if ((read = super.read(b, offset, ct)) != -1) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        int c;
        if (!this.isMarked()) {
            super.mark(1);
        }
        if ((c = super.read()) != -1) {
            ++this.position;
        }
        return c;
    }

    public void position(long offset) {
        if (this.position == offset) {
            return;
        }
        int diff = (int)(offset - this.position);
        long lowerBound = this.position - (long)this.pos;
        long upperBound = lowerBound + (long)this.count;
        if (offset < lowerBound || offset >= upperBound) {
            throw new IllegalAccessError("Offset goes outside current this.buf (TODO: Do buffer fills if positive)");
        }
        this.position = offset;
        this.pos += diff;
        this.markPosition = -1L;
    }

    @Override
    public void mark(int readlimit) {
        this.markPosition = this.position;
        super.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.position = this.markPosition;
        this.markPosition = -1L;
    }

    protected boolean isMarked() {
        return this.markPosition != -1L;
    }

    public long position() {
        return this.position;
    }
}

