/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import com.google.common.io.CountingInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import org.archive.io.ArchiveReader;
import org.archive.io.ArchiveReaderFactory;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.arc.ARCConstants;
import org.archive.io.arc.ARCReader;
import org.archive.io.arc.ARCRecord;
import org.archive.util.FileUtils;
import org.archive.util.zip.GZIPMembersInputStream;
import org.archive.util.zip.GzipHeader;
import org.archive.util.zip.NoGzipMagicException;

public class ARCReaderFactory
extends ArchiveReaderFactory
implements ARCConstants {
    private static final ARCReaderFactory factory = new ARCReaderFactory();

    protected ARCReaderFactory() {
    }

    public static ARCReader get(String arcFileOrUrl) throws MalformedURLException, IOException {
        return (ARCReader)factory.getArchiveReader(arcFileOrUrl);
    }

    public static ARCReader get(String arcFileOrUrl, long offset) throws MalformedURLException, IOException {
        return (ARCReader)factory.getArchiveReader(arcFileOrUrl, offset);
    }

    public static ARCReader get(File f) throws IOException {
        return (ARCReader)factory.getArchiveReader(f);
    }

    public static ARCReader get(File f, long offset) throws IOException {
        return (ARCReader)factory.getArchiveReader(f, offset);
    }

    @Override
    protected ArchiveReader getArchiveReader(File f, long offset) throws IOException {
        return this.getArchiveReader(f, true, offset);
    }

    public static ARCReader get(File f, boolean skipSuffixTest, long offset) throws IOException {
        return (ARCReader)factory.getArchiveReader(f, skipSuffixTest, offset);
    }

    protected ArchiveReader getArchiveReader(File arcFile, boolean skipSuffixTest, long offset) throws IOException {
        ARCReader aRCReader;
        boolean compressed = ARCReaderFactory.testCompressedARCFile(arcFile, skipSuffixTest);
        if (!compressed && !FileUtils.isReadableWithExtensionAndMagic(arcFile, "arc", "filedesc://")) {
            throw new IOException(arcFile.getAbsolutePath() + " is not an Internet Archive ARC file.");
        }
        if (compressed) {
            ARCReaderFactory aRCReaderFactory = factory;
            aRCReaderFactory.getClass();
            aRCReader = aRCReaderFactory.new CompressedARCReader(arcFile, offset);
        } else {
            ARCReaderFactory aRCReaderFactory = factory;
            aRCReaderFactory.getClass();
            aRCReader = aRCReaderFactory.new UncompressedARCReader(arcFile, offset);
        }
        return aRCReader;
    }

    public static ArchiveReader get(String s, InputStream is, boolean atFirstRecord) throws IOException {
        return factory.getArchiveReader(s, is, atFirstRecord);
    }

    @Override
    protected ArchiveReader getArchiveReader(String arc, InputStream is, boolean atFirstRecord) throws IOException {
        InputStream possiblyWrapped = is.markSupported() ? is : new BufferedInputStream(is);
        possiblyWrapped.mark(100);
        boolean compressed = ARCReaderFactory.testCompressedARCStream(possiblyWrapped);
        possiblyWrapped.reset();
        if (compressed) {
            return new CompressedARCReader(arc, possiblyWrapped, atFirstRecord);
        }
        return new UncompressedARCReader(arc, possiblyWrapped, atFirstRecord);
    }

    public static ARCReader get(URL arcUrl, long offset) throws IOException {
        return (ARCReader)factory.getArchiveReader(arcUrl, offset);
    }

    public static ARCReader get(URL arcUrl) throws IOException {
        return (ARCReader)factory.getArchiveReader(arcUrl);
    }

    @Override
    public boolean isCompressed(File arcFile) throws IOException {
        return ARCReaderFactory.testCompressedARCFile(arcFile);
    }

    public static boolean testCompressedARCFile(File arcFile) throws IOException {
        return ARCReaderFactory.testCompressedARCFile(arcFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testCompressedARCFile(File arcFile, boolean skipSuffixCheck) throws IOException {
        boolean compressedARCFile = false;
        FileUtils.assertReadable(arcFile);
        if (!skipSuffixCheck && !arcFile.getName().toLowerCase().endsWith("arc.gz")) {
            return compressedARCFile;
        }
        FileInputStream is = new FileInputStream(arcFile);
        try {
            compressedARCFile = ARCReaderFactory.testCompressedARCStream(is);
        }
        finally {
            ((InputStream)is).close();
        }
        return compressedARCFile;
    }

    public static boolean isARCSuffix(String arcName) {
        return arcName == null ? false : (arcName.toLowerCase().endsWith(".arc.gz") ? true : arcName.toLowerCase().endsWith(".arc"));
    }

    public static boolean testCompressedARCStream(InputStream is) throws IOException {
        boolean compressedARCFile = false;
        GzipHeader gh = null;
        try {
            gh = new GzipHeader(is);
        }
        catch (NoGzipMagicException e) {
            return false;
        }
        byte[] fextra = gh.getFextra();
        if (fextra != null) {
            if (fextra.length >= ARC_GZIP_EXTRA_FIELD.length - 2 && fextra[0] == ARC_GZIP_EXTRA_FIELD[2] && fextra[1] == ARC_GZIP_EXTRA_FIELD[3]) {
                compressedARCFile = true;
            }
        } else {
            compressedARCFile = true;
        }
        return compressedARCFile;
    }

    public class CompressedARCReader
    extends ARCReader {
        public CompressedARCReader(File f) throws IOException {
            this(f, 0L);
        }

        public CompressedARCReader(File f, long offset) throws IOException {
            this.setIn(new GZIPMembersInputStream(this.getInputStream(f, offset)));
            ((GZIPMembersInputStream)this.getIn()).compressedSeek(offset);
            this.setCompressed(offset == 0L);
            this.initialize(f.getAbsolutePath());
        }

        public CompressedARCReader(String f, InputStream is, boolean atFirstRecord) throws IOException {
            this.setIn(new GZIPMembersInputStream(is));
            this.setCompressed(true);
            this.setAlignedOnFirstRecord(atFirstRecord);
            this.initialize(f);
        }

        @Override
        public ARCRecord get(long offset) throws IOException {
            this.cleanupCurrentRecord();
            ((GZIPMembersInputStream)this.getIn()).compressedSeek(offset);
            return this.createArchiveRecord(this.getIn(), offset);
        }

        @Override
        public Iterator<ArchiveRecord> iterator() {
            return new ArchiveReader.ArchiveRecordIterator(){
                private GZIPMembersInputStream gis;
                private Iterator<GZIPMembersInputStream> gzipIterator;
                {
                    this.gis = (GZIPMembersInputStream)CompressedARCReader.this.getIn();
                    this.gzipIterator = this.gis.memberIterator();
                }

                @Override
                protected boolean innerHasNext() {
                    return this.gzipIterator.hasNext();
                }

                @Override
                protected ArchiveRecord innerNext() throws IOException {
                    InputStream is = this.gzipIterator.next();
                    return CompressedARCReader.this.createArchiveRecord(is, Math.max(this.gis.getCurrentMemberStart(), this.gis.getCurrentMemberEnd()));
                }
            };
        }

        @Override
        protected void gotoEOR(ArchiveRecord rec) throws IOException {
            int c;
            while ((c = this.getIn().read()) == 10) {
            }
            if (c == -1) {
                return;
            }
            long skipped = 1L;
            while (this.getIn().read() > -1) {
                ++skipped;
            }
            ArchiveRecordHeader meta = this.getCurrentRecord() != null ? rec.getHeader() : null;
            String message = "Record STARTING at " + ((GZIPMembersInputStream)this.getIn()).getCurrentMemberStart() + " has " + skipped + " trailing byte(s): " + (meta != null ? meta.toString() : "");
            if (this.isStrict()) {
                throw new IOException(message);
            }
            this.logStdErr(Level.WARNING, message);
        }
    }

    public class UncompressedARCReader
    extends ARCReader {
        public UncompressedARCReader(File f) throws IOException {
            this(f, 0L);
        }

        public UncompressedARCReader(File f, long offset) throws IOException {
            this.setIn((InputStream)new CountingInputStream(this.getInputStream(f, offset)));
            this.getIn().skip(offset);
            this.initialize(f.getAbsolutePath());
        }

        public UncompressedARCReader(String f, InputStream is, boolean atFirstRecord) {
            this.setIn((InputStream)new CountingInputStream(is));
            this.setAlignedOnFirstRecord(atFirstRecord);
            this.initialize(f);
        }
    }
}

