/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.URIException;
import org.archive.url.LaxURI;
import org.archive.util.SURT;
import org.archive.util.TextUtils;

public class UsableURI
extends LaxURI
implements CharSequence,
Serializable {
    private static final long serialVersionUID = -1277570889914647093L;
    public static final int MAX_URL_LENGTH = 2083;
    public static final String MASSAGEHOST_PATTERN = "^www\\d*\\.";
    private transient String cachedHost = null;
    private transient String cachedEscapedURI = null;
    private transient String cachedString = null;
    private transient String cachedAuthorityMinusUserinfo = null;
    private transient String surtForm = null;

    protected UsableURI() {
    }

    protected UsableURI(String uri, boolean escaped, String charset) throws URIException {
        super(uri, escaped, charset);
        this.normalize();
    }

    protected UsableURI(UsableURI base, UsableURI relative) throws URIException {
        super(base, relative);
        this.normalize();
    }

    protected UsableURI(String uri, boolean escaped) throws URIException, NullPointerException {
        super(uri, escaped);
        this.normalize();
    }

    public UsableURI resolve(String uri) throws URIException {
        return this.resolve(uri, false, this.getProtocolCharset());
    }

    public UsableURI resolve(String uri, boolean e) throws URIException {
        return this.resolve(uri, e, this.getProtocolCharset());
    }

    public UsableURI resolve(String uri, boolean e, String charset) throws URIException {
        return new UsableURI(this, new UsableURI(uri, e, charset));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UsableURI)) {
            return false;
        }
        UsableURI another = (UsableURI)obj;
        if (!this.equals(this._scheme, another._scheme)) {
            return false;
        }
        if (!this.equals(this._opaque, another._opaque)) {
            return false;
        }
        if (!this.equals(this._authority, another._authority)) {
            return false;
        }
        if (!this.equals(this._path, another._path)) {
            return false;
        }
        return this.equals(this._query, another._query);
    }

    public String getHostBasename() throws URIException {
        return this.getReferencedHost() == null ? null : TextUtils.replaceFirst(MASSAGEHOST_PATTERN, this.getReferencedHost(), "");
    }

    public synchronized String toCustomString() {
        if (this.cachedString == null) {
            this.cachedString = super.toString();
            this.coalesceUriStrings();
        }
        return this.cachedString;
    }

    @Override
    public String toString() {
        return this.toCustomString();
    }

    public synchronized String getEscapedURI() {
        if (this.cachedEscapedURI == null) {
            this.cachedEscapedURI = super.getEscapedURI();
            this.coalesceUriStrings();
        }
        return this.cachedEscapedURI;
    }

    protected void coalesceUriStrings() {
        if (this.cachedString != null && this.cachedEscapedURI != null && this.cachedString.length() == this.cachedEscapedURI.length()) {
            this.cachedString = this.cachedEscapedURI;
        }
    }

    public synchronized String getHost() throws URIException {
        if (this.cachedHost == null && this._host != null) {
            this.cachedHost = super.getHost();
            this.coalesceHostAuthorityStrings();
        }
        return this.cachedHost;
    }

    protected void coalesceHostAuthorityStrings() {
        if (this.cachedAuthorityMinusUserinfo != null && this.cachedHost != null && this.cachedHost.length() == this.cachedAuthorityMinusUserinfo.length()) {
            this.cachedAuthorityMinusUserinfo = this.cachedHost;
        }
    }

    public String getReferencedHost() throws URIException {
        String possibleHost;
        String referencedHost = this.getHost();
        if (referencedHost == null && this.getScheme().equals("dns") && (possibleHost = this.getCurrentHierPath()) != null && possibleHost.matches("[-_\\w\\.:]+")) {
            referencedHost = possibleHost;
        }
        return referencedHost;
    }

    public String getSurtForm() {
        if (this.surtForm == null) {
            this.surtForm = SURT.fromURI(this.toString());
        }
        return this.surtForm;
    }

    public String getAuthorityMinusUserinfo() throws URIException {
        if (this.cachedAuthorityMinusUserinfo == null) {
            int index;
            String tmp = this.getAuthority();
            if (tmp != null && tmp.length() > 0 && (index = tmp.indexOf(64)) >= 0 && index < tmp.length()) {
                tmp = tmp.substring(index + 1);
            }
            this.cachedAuthorityMinusUserinfo = tmp;
            this.coalesceHostAuthorityStrings();
        }
        return this.cachedAuthorityMinusUserinfo;
    }

    @Override
    public int length() {
        return this.getEscapedURI().length();
    }

    @Override
    public char charAt(int index) {
        return this.getEscapedURI().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getEscapedURI().subSequence(start, end);
    }

    public int compareTo(Object arg0) {
        return this.getEscapedURI().compareTo(arg0.toString());
    }

    public static boolean hasScheme(String possibleUrl) {
        boolean result = false;
        for (int i = 0; i < possibleUrl.length(); ++i) {
            char c = possibleUrl.charAt(i);
            if (c == ':') {
                if (i == 0) break;
                result = true;
                break;
            }
            if (!scheme.get(c)) break;
        }
        return result;
    }

    public static String parseFilename(String pathOrUri) throws URISyntaxException {
        String path = pathOrUri;
        if (UsableURI.hasScheme(pathOrUri)) {
            URI url = new URI(pathOrUri);
            path = url.getPath();
        }
        return new File(path).getName();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.toCustomString());
    }

    static {
        hostname.set(95);
    }
}

