/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extract;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import org.archive.extract.ExtractorOutput;
import org.archive.format.gzip.GZIPFormatException;
import org.archive.format.json.SimpleJSONPathSpec;
import org.archive.resource.MetaData;
import org.archive.resource.Resource;
import org.archive.util.StreamCopy;
import org.json.JSONArray;
import org.json.JSONObject;

public class WARCMetadataRecordExtractorOutput
implements ExtractorOutput {
    private static final Logger LOG = Logger.getLogger(WARCMetadataRecordExtractorOutput.class.getName());
    private PrintWriter out;
    SimpleJSONPathSpec formatSpec = new SimpleJSONPathSpec("Envelope.Format");
    SimpleJSONPathSpec warcURL = new SimpleJSONPathSpec("Envelope.WARC-Header-Metadata.WARC-Target-URI");
    SimpleJSONPathSpec warcDate = new SimpleJSONPathSpec("Envelope.WARC-Header-Metadata.WARC-Date");
    SimpleJSONPathSpec warcType = new SimpleJSONPathSpec("Envelope.WARC-Header-Metadata.WARC-Type");
    SimpleJSONPathSpec warcMetadataRecord = new SimpleJSONPathSpec("Envelope.Payload-Metadata.WARC-Metadata-Metadata.Metadata-Records");
    private String outputType = "outlinks";

    public WARCMetadataRecordExtractorOutput(PrintWriter out, String outputType) {
        this.out = out;
        this.outputType = outputType;
    }

    public WARCMetadataRecordExtractorOutput(PrintWriter out) {
        this(out, "outlinks");
    }

    @Override
    public void output(Resource resource) throws IOException {
        OutputStream nullo = ByteStreams.nullOutputStream();
        CountingOutputStream co = new CountingOutputStream(nullo);
        try {
            StreamCopy.copy(resource.getInputStream(), (OutputStream)co);
        }
        catch (GZIPFormatException e) {
            e.printStackTrace();
            return;
        }
        long bytes = co.getCount();
        if (bytes > 0L) {
            LOG.info(bytes + " unconsumed bytes in Resource InputStream.");
        }
        try {
            MetaData m = resource.getMetaData().getTopMetaData();
            String format = this.getEnvelopeFormat(m);
            String origUrl = "TBD";
            String date = "TBD";
            String canUrl = "TBD";
            if (format.equals("WARC")) {
                origUrl = this.getWARCURL(m);
                date = this.getWARCDate(m);
                String type = this.getWARCType(m);
                if (type.equals("metadata")) {
                    String warcMetadataRecord = this.getWARCMetadataRecord(m);
                    JSONArray array = new JSONArray(warcMetadataRecord);
                    String viaUrl = "-";
                    String viaPath = "-";
                    String sourceTag = "-";
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject obj = array.getJSONObject(i);
                        if (this.outputType.equals("outlinks")) {
                            String outLinkValue;
                            String[] linkParts;
                            if (!obj.get("Name").toString().equals("outlink") || (linkParts = (outLinkValue = obj.get("Value").toString()).split(" ")).length <= 2) continue;
                            this.out.format("%s\t%s\t%s\t%s\t\n", origUrl, date, linkParts[0], linkParts[2]);
                            continue;
                        }
                        if (!this.outputType.equals("hopinfo")) continue;
                        String key = obj.get("Name").toString();
                        String value = obj.get("Value").toString();
                        if (key.equals("via")) {
                            viaUrl = value;
                            continue;
                        }
                        if (key.equals("hopsFromSeed")) {
                            viaPath = value;
                            continue;
                        }
                        if (!key.equals("sourceTag")) continue;
                        sourceTag = value;
                    }
                    if (this.outputType.equals("hopinfo")) {
                        this.out.format("%s\t%s\t%s\t%s\t%s\n", origUrl, date, viaUrl, viaPath, sourceTag);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.out.flush();
    }

    private String getEnvelopeFormat(MetaData m) {
        return this.unwrapFirst(this.formatSpec.extract(m), "-");
    }

    private String getWARCURL(MetaData m) {
        return this.unwrapFirst(this.warcURL.extract(m), "-");
    }

    private String getWARCDate(MetaData m) {
        return this.unwrapFirst(this.warcDate.extract(m), "-");
    }

    private String getWARCType(MetaData m) {
        return this.unwrapFirst(this.warcType.extract(m), "-");
    }

    private String getWARCMetadataRecord(MetaData m) {
        return this.unwrapFirst(this.warcMetadataRecord.extract(m), "-");
    }

    private String unwrapFirst(List<List<String>> l, String defaultValue) {
        String v;
        if (l != null && l.size() > 0 && l.get(0) != null && l.get(0).size() > 0 && (v = l.get(0).get(0)) != null && v.length() > 0) {
            return v;
        }
        return defaultValue;
    }
}

