/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.archive.util.iterator.CloseableIterator;

public class LineBufferingIterator
implements CloseableIterator<String> {
    protected CloseableIterator<String> inner;
    protected int maxLines;
    protected boolean reverse;
    protected Iterator<String> currIter;

    public LineBufferingIterator(CloseableIterator<String> inner, int maxLines, boolean reverse) {
        this.inner = inner;
        this.maxLines = maxLines;
        this.reverse = reverse;
    }

    public void bufferInput() {
        if (this.currIter != null) {
            return;
        }
        LinkedList lineBuffer = new LinkedList();
        if (!this.reverse) {
            while (this.inner.hasNext() && lineBuffer.size() < this.maxLines) {
                lineBuffer.addLast(this.inner.next());
            }
            this.currIter = lineBuffer.iterator();
        } else {
            while (this.inner.hasNext()) {
                lineBuffer.addLast(this.inner.next());
                if (lineBuffer.size() <= this.maxLines) continue;
                lineBuffer.removeFirst();
            }
            this.currIter = lineBuffer.descendingIterator();
        }
        try {
            this.inner.close();
            this.inner = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currIter == null) {
            this.bufferInput();
        }
        return this.currIter.hasNext();
    }

    @Override
    public String next() {
        return this.currIter.next();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void remove() {
    }
}

