/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.warc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.archive.format.warc.WARCConstants;
import org.archive.io.WriterPoolMember;
import org.archive.io.warc.WARCConstants;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.io.warc.WARCWriterPoolSettings;
import org.archive.util.ArchiveUtils;

public class WARCWriter
extends WriterPoolMember
implements WARCConstants {
    public static final String TOTALS = "totals";
    public static final String SIZE_ON_DISK = "sizeOnDisk";
    public static final String TOTAL_BYTES = "totalBytes";
    public static final String CONTENT_BYTES = "contentBytes";
    public static final String NUM_RECORDS = "numRecords";
    private static final Logger logger = Logger.getLogger(WARCWriter.class.getName());
    public static byte[] CRLF_BYTES;
    private Map<String, Map<String, Long>> tmpStats;
    private LinkedList<WARCRecordInfo> tmpRecordLog = new LinkedList();

    public WARCWriter(AtomicInteger serialNo, OutputStream out, File f, WARCWriterPoolSettings settings) throws IOException {
        super(serialNo, out, f, settings);
    }

    public WARCWriter(AtomicInteger serialNo, WARCWriterPoolSettings settings) {
        super(serialNo, settings, "warc");
    }

    @Override
    protected String createFile(File file) throws IOException {
        String filename = super.createFile(file);
        this.writeWarcinfoRecord(filename);
        return filename;
    }

    protected void baseCharacterCheck(char c, String parameter) throws IllegalArgumentException {
        if (Character.isISOControl(c) || !Character.isValidCodePoint(c)) {
            throw new IllegalArgumentException("Contains illegal character 0x" + Integer.toHexString(c) + ": " + parameter);
        }
    }

    protected String checkHeaderValue(String value) throws IllegalArgumentException {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            this.baseCharacterCheck(c, value);
            if (!Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("Contains disallowed white space 0x" + Integer.toHexString(c) + ": " + value);
        }
        return value;
    }

    protected String checkHeaderLineMimetypeParameter(String parameter) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder(parameter.length());
        boolean wasWhitespace = false;
        for (int i = 0; i < parameter.length(); ++i) {
            char c = parameter.charAt(i);
            if (Character.isWhitespace(c)) {
                if (wasWhitespace) continue;
                wasWhitespace = true;
                c = ' ';
            } else {
                wasWhitespace = false;
                this.baseCharacterCheck(c, parameter);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String createRecordHeader(WARCRecordInfo metaRecord) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("WARC/1.0").append("\r\n");
        sb.append("WARC-Type").append(": ").append((Object)metaRecord.getType()).append("\r\n");
        if (!StringUtils.isEmpty((String)metaRecord.getUrl())) {
            sb.append("WARC-Target-URI").append(": ").append(this.checkHeaderValue(metaRecord.getUrl())).append("\r\n");
        }
        sb.append("WARC-Date").append(": ").append(metaRecord.getCreate14DigitDate()).append("\r\n");
        if (metaRecord.getExtraHeaders() != null) {
            Iterator i = metaRecord.getExtraHeaders().iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append("\r\n");
            }
        }
        sb.append("WARC-Record-ID").append(": ").append('<').append(metaRecord.getRecordId().toString()).append('>').append("\r\n");
        if (metaRecord.getContentLength() > 0L) {
            sb.append("Content-Type").append(": ").append(this.checkHeaderLineMimetypeParameter(metaRecord.getMimetype())).append("\r\n");
        }
        sb.append("Content-Length").append(": ").append(Long.toString(metaRecord.getContentLength())).append("\r\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecord(WARCRecordInfo recordInfo) throws IOException {
        String header;
        if (recordInfo.getContentLength() == 0L && (recordInfo.getExtraHeaders() == null || recordInfo.getExtraHeaders().size() <= 0)) {
            throw new IllegalArgumentException("Cannot write record of content-length zero and base headers only.");
        }
        try {
            header = this.createRecordHeader(recordInfo);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "could not write record type: " + (Object)((Object)recordInfo.getType()) + "for URL: " + recordInfo.getUrl(), e);
            return;
        }
        long contentBytes = 0L;
        long totalBytes = 0L;
        try {
            long startPosition = this.getPosition();
            this.preWriteRecordTasks();
            byte[] bytes = header.getBytes("UTF-8");
            this.write(bytes);
            totalBytes += (long)bytes.length;
            this.write(CRLF_BYTES);
            totalBytes += (long)CRLF_BYTES.length;
            if (recordInfo.getContentStream() != null && recordInfo.getContentLength() > 0L) {
                totalBytes += (contentBytes += this.copyFrom(recordInfo.getContentStream(), recordInfo.getContentLength(), recordInfo.getEnforceLength()));
            }
            this.write(CRLF_BYTES);
            this.write(CRLF_BYTES);
            this.tally(recordInfo.getType(), contentBytes, totalBytes += (long)(2 * CRLF_BYTES.length), this.getPosition() - startPosition);
            recordInfo.setWARCFilename(this.getFilenameWithoutOccupiedSuffix());
            recordInfo.setWARCFileOffset(startPosition);
            this.tmpRecordLog.add(recordInfo);
        }
        finally {
            this.postWriteRecordTasks();
        }
    }

    public String getFilenameWithoutOccupiedSuffix() {
        String name = this.getFile().getName();
        if (name.endsWith(".open")) {
            name = name.substring(0, name.length() - ".open".length());
        }
        return name;
    }

    protected void tally(WARCConstants.WARCRecordType warcRecordType, long contentBytes, long totalBytes, long sizeOnDisk) {
        Map<String, Long> substats;
        if (this.tmpStats == null) {
            this.tmpStats = new HashMap<String, Map<String, Long>>();
        }
        if ((substats = this.tmpStats.get(warcRecordType.toString())) == null) {
            substats = new HashMap<String, Long>();
            this.tmpStats.put(warcRecordType.toString(), substats);
        }
        this.subtally(substats, contentBytes, totalBytes, sizeOnDisk);
        substats = this.tmpStats.get(TOTALS);
        if (substats == null) {
            substats = new HashMap<String, Long>();
            this.tmpStats.put(TOTALS, substats);
        }
        this.subtally(substats, contentBytes, totalBytes, sizeOnDisk);
    }

    protected void subtally(Map<String, Long> substats, long contentBytes, long totalBytes, long sizeOnDisk) {
        if (substats.get(NUM_RECORDS) == null) {
            substats.put(NUM_RECORDS, 1L);
        } else {
            substats.put(NUM_RECORDS, substats.get(NUM_RECORDS) + 1L);
        }
        if (substats.get(CONTENT_BYTES) == null) {
            substats.put(CONTENT_BYTES, contentBytes);
        } else {
            substats.put(CONTENT_BYTES, substats.get(CONTENT_BYTES) + contentBytes);
        }
        if (substats.get(TOTAL_BYTES) == null) {
            substats.put(TOTAL_BYTES, totalBytes);
        } else {
            substats.put(TOTAL_BYTES, substats.get(TOTAL_BYTES) + totalBytes);
        }
        if (substats.get(SIZE_ON_DISK) == null) {
            substats.put(SIZE_ON_DISK, sizeOnDisk);
        } else {
            substats.put(SIZE_ON_DISK, substats.get(SIZE_ON_DISK) + sizeOnDisk);
        }
    }

    protected URI generateRecordId(Map<String, String> qualifiers) throws IOException {
        return ((WARCWriterPoolSettings)this.settings).getRecordIDGenerator().getQualifiedRecordID(qualifiers);
    }

    protected URI generateRecordId(String key, String value) throws IOException {
        return ((WARCWriterPoolSettings)this.settings).getRecordIDGenerator().getQualifiedRecordID(key, value);
    }

    public URI writeWarcinfoRecord(String filename) throws IOException {
        return this.writeWarcinfoRecord(filename, null);
    }

    public URI writeWarcinfoRecord(String filename, String description) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setType(WARCConstants.WARCRecordType.warcinfo);
        recordInfo.setCreate14DigitDate(ArchiveUtils.getLog14Date());
        recordInfo.setMimetype("application/warc-fields");
        if (filename.endsWith(".open")) {
            filename = filename.substring(0, filename.length() - ".open".length());
        }
        recordInfo.addExtraHeader("WARC-Filename", filename);
        if (description != null && description.length() > 0) {
            recordInfo.addExtraHeader("Content-Description", description);
        }
        byte[] warcinfoBody = null;
        if (this.settings.getMetadata() == null) {
            warcinfoBody = "TODO: Unimplemented".getBytes();
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Iterator<String> i = this.settings.getMetadata().iterator();
            while (i.hasNext()) {
                baos.write(i.next().toString().getBytes("UTF-8"));
            }
            warcinfoBody = baos.toByteArray();
        }
        recordInfo.setContentStream(new ByteArrayInputStream(warcinfoBody));
        recordInfo.setContentLength(warcinfoBody.length);
        recordInfo.setEnforceLength(true);
        recordInfo.setRecordId(this.generateRecordId("type", WARCConstants.WARCRecordType.warcinfo.toString()));
        this.writeRecord(recordInfo);
        return recordInfo.getRecordId();
    }

    public void resetTmpStats() {
        if (this.tmpStats != null) {
            for (Map<String, Long> substats : this.tmpStats.values()) {
                for (Map.Entry<String, Long> entry : substats.entrySet()) {
                    entry.setValue(0L);
                }
            }
        }
    }

    public Map<String, Map<String, Long>> getTmpStats() {
        return this.tmpStats;
    }

    public static long getStat(Map<String, Map<String, Long>> map, String key, String subkey) {
        if (map != null && map.get(key) != null && map.get(key).get(subkey) != null) {
            return map.get(key).get(subkey);
        }
        return 0L;
    }

    public static long getStat(ConcurrentMap<String, ConcurrentMap<String, AtomicLong>> map, String key, String subkey) {
        if (map != null && map.get(key) != null && ((ConcurrentMap)map.get(key)).get(subkey) != null) {
            return ((AtomicLong)((ConcurrentMap)map.get(key)).get(subkey)).get();
        }
        return 0L;
    }

    public void resetTmpRecordLog() {
        this.tmpRecordLog.clear();
    }

    public Iterable<WARCRecordInfo> getTmpRecordLog() {
        return this.tmpRecordLog;
    }

    static {
        try {
            CRLF_BYTES = "\r\n".getBytes("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

