/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessUtils {
    private static final Logger LOGGER = Logger.getLogger(ProcessUtils.class.getName());

    protected ProcessUtils() {
    }

    public static ProcessResult exec(String[] args) throws IOException {
        int exitVal;
        ProcessUtils pu;
        Process p = Runtime.getRuntime().exec(args);
        ProcessUtils processUtils = pu = new ProcessUtils();
        processUtils.getClass();
        StreamGobbler err = processUtils.new StreamGobbler(p.getErrorStream(), "stderr");
        err.setDaemon(true);
        err.start();
        ProcessUtils processUtils2 = pu;
        processUtils2.getClass();
        StreamGobbler out = processUtils2.new StreamGobbler(p.getInputStream(), "stdout");
        out.setDaemon(true);
        out.start();
        try {
            exitVal = p.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Wait on process " + Arrays.toString(args) + " interrupted: " + e.getMessage());
        }
        ProcessUtils processUtils3 = pu;
        processUtils3.getClass();
        ProcessResult result = processUtils3.new ProcessResult(args, exitVal, out.getSink(), err.getSink());
        if (exitVal != 0) {
            throw new IOException(result.toString());
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(result.toString());
        }
        return result;
    }

    public class ProcessResult {
        private final String[] args;
        private final int result;
        private final String stdout;
        private final String stderr;

        protected ProcessResult(String[] args, int result, String stdout, String stderr) {
            this.args = args;
            this.result = result;
            this.stderr = stderr;
            this.stdout = stdout;
        }

        public int getResult() {
            return this.result;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.args.length; ++i) {
                sb.append(this.args[i]);
                sb.append(", ");
            }
            return sb.toString() + " exit code: " + this.result + (this.stderr != null && this.stderr.length() > 0 ? "\nSTDERR: " + this.stderr : "") + (this.stdout != null && this.stdout.length() > 0 ? "\nSTDOUT: " + this.stdout : "");
        }
    }

    protected class StreamGobbler
    extends Thread {
        private final InputStream is;
        private final StringBuffer sink = new StringBuffer();

        protected StreamGobbler(InputStream is, String name) {
            this.is = is;
            this.setName(name);
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.sink.append(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public String getSink() {
            return this.sink.toString();
        }
    }
}

