/*
 * Decompiled with CFR 0.152.
 */
package org.archive.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpParams;

public final class ThreadLocalHttpConnectionManager
implements HttpConnectionManager {
    private static final CloserThread closer = new CloserThread();
    private static final Logger logger = Logger.getLogger(ThreadLocalHttpConnectionManager.class.getName());
    private final ThreadLocal<ConnectionInfo> tl = new ThreadLocal<ConnectionInfo>(){

        @Override
        protected synchronized ConnectionInfo initialValue() {
            return new ConnectionInfo();
        }
    };
    private HttpConnectionManagerParams params = new HttpConnectionManagerParams();

    private ConnectionInfo getConnectionInfo() {
        return this.tl.get();
    }

    private static boolean finishLastResponse(HttpConnection conn) {
        InputStream lastResponse = conn.getLastResponseInputStream();
        if (lastResponse != null) {
            conn.setLastResponseInputStream(null);
            try {
                lastResponse.close();
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        return this.getConnection(hostConfiguration, 0L);
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.params.isStaleCheckingEnabled();
    }

    public void setConnectionStaleCheckingEnabled(boolean connectionStaleCheckingEnabled) {
        this.params.setStaleCheckingEnabled(connectionStaleCheckingEnabled);
    }

    public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
        ConnectionInfo ci = this.getConnectionInfo();
        HttpConnection httpConnection = ci.conn;
        if (!(httpConnection != null && ThreadLocalHttpConnectionManager.finishLastResponse(httpConnection) && hostConfiguration.hostEquals(httpConnection) && hostConfiguration.proxyEquals(httpConnection))) {
            if (httpConnection != null && httpConnection.isOpen()) {
                closer.closeConnection(httpConnection);
            }
            httpConnection = new HttpConnection(hostConfiguration);
            httpConnection.setHttpConnectionManager((HttpConnectionManager)this);
            httpConnection.getParams().setDefaults((HttpParams)this.params);
            ci.conn = httpConnection;
            httpConnection.setHost(hostConfiguration.getHost());
            httpConnection.setPort(hostConfiguration.getPort());
            httpConnection.setProtocol(hostConfiguration.getProtocol());
            httpConnection.setLocalAddress(hostConfiguration.getLocalAddress());
            httpConnection.setProxyHost(hostConfiguration.getProxyHost());
            httpConnection.setProxyPort(hostConfiguration.getProxyPort());
        }
        ci.idleStartTime = Long.MAX_VALUE;
        return httpConnection;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) {
        return this.getConnectionWithTimeout(hostConfiguration, timeout);
    }

    public void releaseConnection(HttpConnection conn) {
        ConnectionInfo ci = this.getConnectionInfo();
        HttpConnection httpConnection = ci.conn;
        if (conn != httpConnection) {
            throw new IllegalStateException("Unexpected release of an unknown connection.");
        }
        ThreadLocalHttpConnectionManager.finishLastResponse(httpConnection);
        ci.idleStartTime = System.currentTimeMillis();
    }

    public HttpConnectionManagerParams getParams() {
        return this.params;
    }

    public void setParams(HttpConnectionManagerParams p) {
        if (p == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = p;
    }

    public void closeIdleConnections(long idleTimeout) {
        long maxIdleTime = System.currentTimeMillis() - idleTimeout;
        ConnectionInfo ci = this.getConnectionInfo();
        if (ci.idleStartTime <= maxIdleTime) {
            ci.conn.close();
        }
    }

    private static final class CloserThread
    extends Thread {
        private List<HttpConnection> connections = new ArrayList<HttpConnection>();
        private static final int SLEEP_INTERVAL = 5000;

        public CloserThread() {
            super("HttpConnection closer");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeConnection(HttpConnection conn) {
            List<HttpConnection> list = this.connections;
            synchronized (list) {
                this.connections.add(conn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    List<HttpConnection> s;
                    Thread.sleep(5000L);
                    List<HttpConnection> list = this.connections;
                    synchronized (list) {
                        s = this.connections;
                        this.connections = new ArrayList<HttpConnection>();
                    }
                    logger.log(Level.INFO, "Closing " + s.size() + " HttpConnections");
                    Iterator<HttpConnection> it = s.iterator();
                    while (it.hasNext()) {
                        HttpConnection conn = it.next();
                        conn.close();
                        conn.setHttpConnectionManager(null);
                        it.remove();
                    }
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static final class ConnectionInfo {
        private HttpConnection conn = null;
        private long idleStartTime = Long.MAX_VALUE;

        private ConnectionInfo() {
        }
    }
}

