/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import com.google.common.net.InetAddresses;
import java.net.IDN;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.url.HandyURL;
import org.archive.url.URLCanonicalizer;

public class BasicURLCanonicalizer
implements URLCanonicalizer {
    Pattern OCTAL_IP = Pattern.compile("^(0[0-7]*)(\\.[0-7]+)?(\\.[0-7]+)?(\\.[0-7]+)?$");
    Pattern DECIMAL_IP = Pattern.compile("^([1-9][0-9]*)(\\.[0-9]+)?(\\.[0-9]+)?(\\.[0-9]+)?$");
    private static final Pattern SINGLE_FORWARDSLASH_PATTERN = Pattern.compile("/");
    protected static Charset _UTF8 = null;

    @Override
    public void canonicalize(HandyURL url) {
        url.setHash(null);
        url.setAuthUser(this.minimalEscape(url.getAuthUser()));
        url.setAuthPass(this.minimalEscape(url.getAuthPass()));
        url.setQuery(this.minimalEscape(url.getQuery()));
        String hostE = this.unescapeRepeatedly(url.getHost());
        String host = null;
        if (hostE != null) {
            try {
                host = IDN.toASCII(hostE);
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().contains("A prohibited code point was found")) {
                    // empty if block
                }
                host = hostE;
            }
            host = host.replaceAll("^\\.+", "").replaceAll("\\.\\.+", ".").replaceAll("\\.$", "");
        }
        String ip = null;
        ip = this.attemptIPFormats(host);
        if (ip != null) {
            host = ip;
        } else if (host != null) {
            host = this.escapeOnce(host.toLowerCase());
        }
        url.setHost(host);
        String path = this.unescapeRepeatedly(url.getPath());
        url.setPath(this.escapeOnce(this.normalizePath(path)));
    }

    public String normalizePath(String path) {
        if (path == null) {
            path = "/";
        } else {
            String[] paths = SINGLE_FORWARDSLASH_PATTERN.split(path, -1);
            ArrayList<String> keptPaths = new ArrayList<String>();
            boolean first = true;
            for (String p : paths) {
                if (first) {
                    first = false;
                    continue;
                }
                if (p.compareTo(".") == 0) continue;
                if (p.compareTo("..") == 0) {
                    if (keptPaths.size() > 0) {
                        keptPaths.remove(keptPaths.size() - 1);
                        continue;
                    }
                    keptPaths.add(p);
                    continue;
                }
                keptPaths.add(p);
            }
            int numKept = keptPaths.size();
            if (numKept == 0) {
                path = "/";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("/");
                for (int i = 0; i < numKept - 1; ++i) {
                    String p;
                    p = (String)keptPaths.get(i);
                    if (p.length() <= 0) continue;
                    sb.append(p).append("/");
                }
                sb.append((String)keptPaths.get(numKept - 1));
                path = sb.toString();
            }
        }
        return path;
    }

    public String attemptIPFormats(String host) {
        if (host == null) {
            return null;
        }
        if (host.matches("^\\d+$")) {
            try {
                Long l = Long.parseLong(host);
                return InetAddresses.fromInteger((int)l.intValue()).getHostAddress();
            }
            catch (NumberFormatException l) {}
        } else {
            Matcher m = this.OCTAL_IP.matcher(host);
            if (m.matches()) {
                int parts = m.groupCount();
                if (parts > 4) {
                    return null;
                }
                int[] ip = new int[]{0, 0, 0, 0};
                for (int i = 0; i < parts; ++i) {
                    int octet;
                    try {
                        octet = Integer.parseInt(m.group(i + 1).substring(i == 0 ? 0 : 1), 8);
                    }
                    catch (Exception e) {
                        return null;
                    }
                    if (octet < 0 || octet > 255) {
                        return null;
                    }
                    ip[i] = octet;
                }
                return String.format("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);
            }
            Matcher m2 = this.DECIMAL_IP.matcher(host);
            if (m2.matches()) {
                int parts = m2.groupCount();
                if (parts > 4) {
                    return null;
                }
                int[] ip = new int[]{0, 0, 0, 0};
                for (int i = 0; i < parts; ++i) {
                    int octet;
                    String m2Group = m2.group(i + 1);
                    if (m2Group == null) {
                        return null;
                    }
                    try {
                        octet = Integer.parseInt(m2Group.substring(i == 0 ? 0 : 1));
                    }
                    catch (Exception e) {
                        return null;
                    }
                    if (octet < 0 || octet > 255) {
                        return null;
                    }
                    ip[i] = octet;
                }
                return String.format("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);
            }
        }
        return null;
    }

    public String minimalEscape(String input) {
        return this.escapeOnce(this.unescapeRepeatedly(input));
    }

    protected static Charset UTF8() {
        if (_UTF8 == null) {
            _UTF8 = Charset.forName("UTF-8");
        }
        return _UTF8;
    }

    public String escapeOnce(String input) {
        if (input == null) {
            return null;
        }
        byte[] utf8bytes = input.getBytes(BasicURLCanonicalizer.UTF8());
        StringBuilder sb = null;
        boolean ok = false;
        for (int i = 0; i < utf8bytes.length; ++i) {
            int b = utf8bytes[i] & 0xFF;
            ok = false;
            if (b > 32 && b < 128 && b != 35) {
                boolean bl = ok = b != 37;
            }
            if (ok) {
                if (sb == null) continue;
                sb.append((char)b);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(input.substring(0, i));
            }
            sb.append("%");
            String hex = Integer.toHexString(b).toUpperCase();
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        if (sb == null) {
            return input;
        }
        return sb.toString();
    }

    public String unescapeRepeatedly(String input) {
        if (input == null) {
            return null;
        }
        String un;
        while ((un = this.decode(input)).compareTo(input) != 0) {
            input = un;
        }
        return input;
    }

    public String decode(String input) {
        StringBuilder sb = null;
        int pctUtf8SeqStart = -1;
        ByteBuffer bbuf = null;
        CharsetDecoder utf8decoder = null;
        int i = 0;
        while (i < input.length()) {
            int h2;
            int h1;
            char c = input.charAt(i);
            if (i <= input.length() - 3 && c == '%' && (h1 = this.getHex(input.charAt(i + 1))) >= 0 && (h2 = this.getHex(input.charAt(i + 2))) >= 0) {
                if (sb == null) {
                    sb = new StringBuilder(input.length());
                    if (i > 0) {
                        sb.append(input.substring(0, i));
                    }
                }
                int b = (h1 << 4) + h2 & 0xFF;
                if (pctUtf8SeqStart < 0 && b < 128) {
                    sb.append((char)b);
                } else {
                    if (pctUtf8SeqStart < 0) {
                        pctUtf8SeqStart = i;
                        if (bbuf == null) {
                            bbuf = ByteBuffer.allocate((input.length() - i) / 3);
                        }
                    }
                    bbuf.put((byte)b);
                }
                i += 3;
                continue;
            }
            if (pctUtf8SeqStart >= 0) {
                if (utf8decoder == null) {
                    utf8decoder = BasicURLCanonicalizer.UTF8().newDecoder();
                }
                this.appendDecodedPctUtf8(sb, bbuf, input, pctUtf8SeqStart, i, utf8decoder);
                pctUtf8SeqStart = -1;
                bbuf.clear();
            }
            if (sb != null) {
                sb.append(c);
            }
            ++i;
        }
        if (pctUtf8SeqStart >= 0) {
            if (utf8decoder == null) {
                utf8decoder = BasicURLCanonicalizer.UTF8().newDecoder();
            }
            this.appendDecodedPctUtf8(sb, bbuf, input, pctUtf8SeqStart, i, utf8decoder);
        }
        if (sb != null) {
            return sb.toString();
        }
        return input;
    }

    private void appendDecodedPctUtf8(StringBuilder sb, ByteBuffer bbuf, String inputStr, int seqStart, int seqEnd, CharsetDecoder utf8decoder) {
        utf8decoder.reset();
        CharBuffer cbuf = CharBuffer.allocate(bbuf.position());
        bbuf.flip();
        while (bbuf.position() < bbuf.limit()) {
            CoderResult coderResult = utf8decoder.decode(bbuf, cbuf, true);
            sb.append(cbuf.flip());
            if (coderResult.isMalformed()) {
                CharSequence undecodablePctHex = inputStr.subSequence(seqStart + 3 * bbuf.position(), seqStart + 3 * bbuf.position() + 3 * coderResult.length());
                sb.append(undecodablePctHex);
                bbuf.position(bbuf.position() + coderResult.length());
            }
            cbuf.clear();
        }
    }

    public int getHex(int b) {
        if (b < 48) {
            return -1;
        }
        if (b <= 57) {
            return b - 48;
        }
        if (b < 65) {
            return -1;
        }
        if (b <= 70) {
            return 10 + (b - 65);
        }
        if (b < 97) {
            return -1;
        }
        if (b <= 102) {
            return 10 + (b - 97);
        }
        return -1;
    }
}

