/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import org.apache.commons.httpclient.URIException;
import org.archive.url.UsableURI;
import org.archive.url.UsableURIFactory;
import org.archive.util.SURT;

public class SURTTokenizer {
    private static final String EXACT_SUFFIX = "\t";
    private String remainder;
    private boolean triedExact;
    private boolean triedFull;
    private boolean choppedArgs;
    private boolean choppedPath;
    private boolean choppedLogin;
    private boolean choppedPort;

    public SURTTokenizer(String url) throws URIException {
        this.remainder = url.startsWith("(") ? url : SURTTokenizer.getKey(url, false);
    }

    public String nextSearch() {
        int lastComma;
        if (!this.triedExact) {
            this.triedExact = true;
            return this.remainder + EXACT_SUFFIX;
        }
        if (!this.triedFull) {
            this.triedFull = true;
            if (this.remainder.endsWith(")/")) {
                this.choppedPath = true;
            }
            return this.remainder;
        }
        if (!this.choppedArgs) {
            this.choppedArgs = true;
            int argStart = this.remainder.indexOf(63);
            if (argStart != -1) {
                this.remainder = this.remainder.substring(0, argStart);
                return this.remainder;
            }
        }
        if (!this.choppedPath) {
            int lastSlash = this.remainder.lastIndexOf(47);
            if (lastSlash != -1) {
                if (lastSlash == this.remainder.length() - 1) {
                    if (this.remainder.endsWith(")/")) {
                        String tmp = this.remainder;
                        this.remainder = this.remainder.substring(0, lastSlash - 1);
                        this.choppedPath = true;
                        return tmp;
                    }
                    this.remainder = this.remainder.substring(0, lastSlash);
                    return this.remainder;
                }
                if (this.remainder.charAt(lastSlash - 1) == ')') {
                    String tmp = this.remainder.substring(0, lastSlash + 1);
                    this.remainder = this.remainder.substring(0, lastSlash - 1);
                    return tmp;
                }
                this.remainder = this.remainder.substring(0, lastSlash);
                return this.remainder;
            }
            this.choppedPath = true;
        }
        if (!this.choppedLogin) {
            this.choppedLogin = true;
            int lastAt = this.remainder.lastIndexOf(64);
            if (lastAt != -1) {
                String tmp = this.remainder;
                this.remainder = this.remainder.substring(0, lastAt);
                return tmp;
            }
        }
        if (!this.choppedPort) {
            this.choppedPort = true;
            int lastColon = this.remainder.lastIndexOf(58);
            if (lastColon != -1) {
                return this.remainder;
            }
        }
        if ((lastComma = this.remainder.lastIndexOf(44)) == -1) {
            return null;
        }
        this.remainder = this.remainder.substring(0, lastComma);
        return this.remainder;
    }

    public static String exactKey(String url) throws URIException {
        return SURTTokenizer.getKey(url, false);
    }

    public static String prefixKey(String url) throws URIException {
        return SURTTokenizer.getKey(url, true);
    }

    public static String addImpliedHttpIfNecessary(String u) {
        int colon = u.indexOf(58);
        int period = u.indexOf(46);
        if (colon == -1 || period >= 0 && period < colon) {
            u = "http://" + u;
        }
        return u;
    }

    private static String getKey(String url, boolean prefix) throws URIException {
        String key = SURTTokenizer.addImpliedHttpIfNecessary(url);
        UsableURI uuri = UsableURIFactory.getInstance(key);
        key = uuri.getScheme() + "://" + uuri.getAuthority() + uuri.getEscapedPathQuery();
        int hashPos = (key = SURT.fromURI(key)).indexOf(35);
        if (hashPos != -1) {
            key = key.substring(0, hashPos);
        }
        if (key.startsWith("http://")) {
            key = key.substring(7);
        }
        if (prefix && key.endsWith(",)/")) {
            key = key.substring(0, key.length() - 3);
        }
        return key;
    }
}

