/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.archive.util.FileUtils;

public abstract class TmpDirTestCase
extends TestCase {
    public static final String TEST_TMP_SYSTEM_PROPERTY_NAME = "testtmpdir";
    public static final String DEFAULT_TEST_TMP_DIR = File.separator + "tmp" + File.separator + "heritrix-junit-tests";
    private File tmpDir = null;

    public TmpDirTestCase() {
    }

    public TmpDirTestCase(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tmpDir = TmpDirTestCase.tmpDir();
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void cleanUpOldFiles(String basename) {
        this.cleanUpOldFiles(this.getTmpDir(), basename);
    }

    public void cleanUpOldFiles(File basedir, String prefix) {
        File[] files = FileUtils.getFilesWithPrefix(basedir, prefix);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                org.apache.commons.io.FileUtils.deleteQuietly((File)files[i]);
            }
        }
    }

    public static File tmpDir() throws IOException {
        String tmpDirStr = System.getProperty(TEST_TMP_SYSTEM_PROPERTY_NAME);
        tmpDirStr = tmpDirStr == null ? DEFAULT_TEST_TMP_DIR : tmpDirStr;
        File tmpDir = new File(tmpDirStr);
        FileUtils.ensureWriteableDirectory(tmpDir);
        if (!tmpDir.canWrite()) {
            throw new IOException(tmpDir.getAbsolutePath() + " is unwriteable.");
        }
        return tmpDir;
    }
}

