/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.io.IOException;
import java.util.Iterator;
import org.archive.util.iterator.AbstractPeekableIterator;
import org.archive.util.iterator.CloseableIteratorUtil;

public class StartBoundedStringIterator
extends AbstractPeekableIterator<String> {
    private Iterator<String> inner;
    private String boundary;
    private boolean done = false;
    private boolean started = false;
    private int flip = 1;

    public StartBoundedStringIterator(Iterator<String> inner, String boundary) {
        this(inner, boundary, false);
    }

    public StartBoundedStringIterator(Iterator<String> inner, String boundary, boolean reverse) {
        this.inner = inner;
        this.boundary = boundary;
        this.done = false;
        this.started = false;
        this.flip = reverse ? -1 : 1;
    }

    @Override
    public String getNextInner() {
        if (this.done) {
            return null;
        }
        if (this.started && this.inner.hasNext()) {
            String tmp = this.inner.next();
            if (tmp == null) {
                this.done = true;
                return null;
            }
            return tmp;
        }
        while (this.inner.hasNext()) {
            String tmp = this.inner.next();
            int cmp = this.boundary.compareTo(tmp) * this.flip;
            if (cmp > 0) continue;
            this.started = true;
            return tmp;
        }
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.done = true;
        return null;
    }

    @Override
    public void close() throws IOException {
        CloseableIteratorUtil.attemptClose(this.inner);
    }
}

