/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.movie.FontDefinition;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Shape;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.structs.Rect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Font
extends Symbol {
    protected Object font1Key = new Object();
    protected Object font2Key = new Object();
    protected FontDefinition fontDef;
    protected HashMap glyphs = new HashMap();
    protected HashMap indices = new HashMap();
    protected ArrayList glyphList = new ArrayList();
    protected int languageCode = 0;

    public int getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(int code) {
        this.languageCode = code;
    }

    public FontDefinition getDefinition() {
        return this.fontDef;
    }

    public Font(FontDefinition fontDef) {
        this.fontDef = fontDef;
    }

    public List getGlyphList() {
        return this.glyphList;
    }

    public void loadGlyphs(String chars) throws NoGlyphException {
        char[] chs = chars.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            this.getGlyph(chs[i], null);
        }
    }

    public void loadAllGlyphs() {
        ArrayList list = this.fontDef.getGlyphList();
        for (FontDefinition.Glyph g : list) {
            this.addGlyph(g);
        }
    }

    public Chars chars(String chars, double fontSize) throws NoGlyphException {
        return new Chars(chars, fontSize);
    }

    protected FontDefinition.Glyph getGlyph(int code, int[] index) throws NoGlyphException {
        Integer codeI = new Integer(code);
        FontDefinition.Glyph g = (FontDefinition.Glyph)this.glyphs.get(codeI);
        if (g != null) {
            if (index != null) {
                Integer idx = (Integer)this.indices.get(codeI);
                index[0] = idx;
            }
            return g;
        }
        g = this.fontDef.getGlyph(code);
        if (g == null) {
            throw new NoGlyphException(code);
        }
        int idx = this.addGlyph(g);
        if (index != null) {
            index[0] = idx;
        }
        return g;
    }

    public int addGlyph(FontDefinition.Glyph glyph) {
        int idx = this.glyphs.size();
        if (glyph.getCode() > 0) {
            Integer codeI = new Integer(glyph.getCode());
            this.indices.put(codeI, new Integer(idx));
            this.glyphs.put(codeI, glyph);
        }
        this.glyphList.add(glyph);
        return idx;
    }

    public void setCode(int index, int code) {
        if (index >= this.glyphList.size()) {
            return;
        }
        FontDefinition.Glyph g = (FontDefinition.Glyph)this.glyphList.get(index);
        g.setCode(code);
        Integer codeI = new Integer(code);
        this.indices.put(codeI, new Integer(index));
        this.glyphs.put(codeI, g);
    }

    protected int define(boolean textFont, Movie movie, SWFTagTypes tagwriter) throws IOException {
        Integer integerId;
        Integer n = integerId = textFont ? (Integer)movie.definedSymbols.get(this.font1Key) : (Integer)movie.definedSymbols.get(this.font2Key);
        if (integerId == null) {
            if (textFont) {
                integerId = new Integer(this.defineFont1(movie, tagwriter));
                movie.definedSymbols.put(this.font1Key, integerId);
            } else {
                integerId = new Integer(this.defineFont2(movie, tagwriter));
                movie.definedSymbols.put(this.font2Key, integerId);
            }
        }
        this.id = integerId;
        return this.id;
    }

    protected int defineFont1(Movie movie, SWFTagTypes tagwriter) throws IOException {
        int id = this.getNextId(movie);
        SWFVectors vecs = tagwriter.tagDefineFont(id, this.glyphList.size());
        for (FontDefinition.Glyph g : this.glyphList) {
            Shape s = g.getShape();
            s.writeGlyph(vecs);
        }
        if (this.fontDef.getName() != null) {
            int flags = 0;
            if (this.fontDef.isUnicode()) {
                flags |= 0x20;
            }
            if (this.fontDef.isShiftJIS()) {
                flags |= 0x10;
            }
            if (this.fontDef.isAnsi()) {
                flags |= 8;
            }
            if (this.fontDef.isItalic()) {
                flags |= 4;
            }
            if (this.fontDef.isBold()) {
                flags |= 2;
            }
            if (movie.getVersion() >= 6 && this.languageCode != 0) {
                tagwriter.tagDefineFontInfo2(id, this.fontDef.getName(), flags, this.getCodes(), this.languageCode);
            } else {
                tagwriter.tagDefineFontInfo(id, this.fontDef.getName(), flags, this.getCodes());
            }
        }
        return id;
    }

    protected int defineFont2(Movie movie, SWFTagTypes tagwriter) throws IOException {
        int id = this.getNextId(movie);
        int glyphCount = this.glyphList.size();
        int[] codes = new int[glyphCount];
        Rect[] bounds = new Rect[glyphCount];
        int[] advances = new int[glyphCount];
        int i = 0;
        for (FontDefinition.Glyph g : this.glyphList) {
            codes[i] = g.getCode();
            advances[i] = (int)(g.getAdvance() * 20.0);
            double[] bound = g.getShape().getBoundingRectangle();
            bounds[i] = new Rect((int)(bound[0] * 20.0), (int)(bound[1] * 20.0), (int)(bound[2] * 20.0), (int)(bound[3] * 20.0));
            ++i;
        }
        ArrayList kerns = this.fontDef.getKerningPairList();
        int kernCount = kerns.size();
        int[] kern1 = new int[kernCount];
        int[] kern2 = new int[kernCount];
        int[] kernOff = new int[kernCount];
        i = 0;
        for (FontDefinition.KerningPair pair : kerns) {
            kern1[i] = pair.getCode1();
            kern2[i] = pair.getCode2();
            kernOff[i] = (int)(pair.getAdjustment() * 20.0);
            ++i;
        }
        int flags = 0;
        if (this.fontDef.hasMetrics()) {
            flags |= 0x80;
        }
        if (this.fontDef.isShiftJIS()) {
            flags |= 0x40;
        }
        if (this.fontDef.isUnicode()) {
            flags |= 0x20;
        }
        if (this.fontDef.isAnsi()) {
            flags |= 0x10;
        }
        if (this.fontDef.isItalic()) {
            flags |= 2;
        }
        if (this.fontDef.isBold()) {
            flags |= 1;
        }
        SWFVectors vecs = tagwriter.tagDefineFont2(id, flags, this.fontDef.getName(), glyphCount, (int)(this.fontDef.getAscent() * 20.0), (int)(this.fontDef.getDescent() * 20.0), (int)(this.fontDef.getLeading() * 20.0), codes, advances, bounds, kern1, kern2, kernOff);
        for (FontDefinition.Glyph g : this.glyphList) {
            Shape s = g.getShape();
            s.writeGlyph(vecs);
        }
        return id;
    }

    protected int[] getCodes() {
        int[] codes = new int[this.glyphList.size()];
        for (int i = 0; i < codes.length; ++i) {
            FontDefinition.Glyph g = (FontDefinition.Glyph)this.glyphList.get(i);
            codes[i] = g.getCode();
        }
        return codes;
    }

    @Override
    protected int defineSymbol(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionwriter) throws IOException {
        return this.id;
    }

    public class Chars {
        protected String chars;
        protected double size;
        protected int[] indices;
        protected int[] advances;
        protected double totalAdvance;
        protected double ascent;
        protected double descent;
        protected double leftMargin;
        protected double rightMargin;

        public String toString() {
            return this.chars;
        }

        public Font getFont() {
            return Font.this;
        }

        public double getSize() {
            return this.size;
        }

        public double getTotalAdvance() {
            return this.totalAdvance;
        }

        public double getAscent() {
            return this.ascent;
        }

        public double getDescent() {
            return this.descent;
        }

        public double getLeftMargin() {
            return this.leftMargin;
        }

        public double getRightMargin() {
            return this.rightMargin;
        }

        protected Chars(String chars, double size) throws NoGlyphException {
            this.chars = chars;
            this.size = size;
            this.init();
        }

        protected void init() throws NoGlyphException {
            char[] codes = this.chars.toCharArray();
            this.indices = new int[codes.length];
            this.advances = new int[codes.length];
            double maxAscent = 0.0;
            double maxDescent = 0.0;
            double scale = this.size * 20.0 / 1024.0;
            for (int i = 0; i < codes.length; ++i) {
                double advance;
                char code = codes[i];
                int[] index = new int[1];
                FontDefinition.Glyph glyph = Font.this.getGlyph(code, index);
                this.indices[i] = index[0];
                if (glyph == null) continue;
                Shape shape = glyph.getShape();
                double[] outline = shape.getBoundingRectangle();
                double x1 = outline[0] * scale;
                double y1 = outline[1] * scale;
                double x2 = outline[2] * scale;
                double y2 = outline[3] * scale;
                if (maxAscent < -y1) {
                    maxAscent = -y1;
                }
                if (maxDescent < y2) {
                    maxDescent = y2;
                }
                if ((advance = glyph.getAdvance() * scale) == 0.0) {
                    advance = x2 - x1;
                }
                if (i < codes.length - 1) {
                    advance += Font.this.fontDef.getKerningOffset(code, codes[i + 1]) * scale;
                }
                this.totalAdvance += advance;
                this.advances[i] = (int)(advance * 20.0);
                if (i == 0) {
                    this.leftMargin = -y1;
                }
                if (i != codes.length - 1) continue;
                this.rightMargin = x2 - advance;
            }
            this.ascent = Font.this.fontDef.getAscent() * scale;
            if (this.ascent == 0.0) {
                this.ascent = maxAscent;
            }
            this.descent = Font.this.fontDef.getDescent() * scale;
            if (this.descent == 0.0) {
                this.descent = maxDescent;
            }
        }
    }

    public class NoGlyphException
    extends Exception {
        public int code;

        public NoGlyphException(int code) {
            super("The font does not have a glyph definition for code " + code);
            this.code = code;
        }
    }
}

