/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.sound.ADPCMConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ADPCMEncodeStream
implements ADPCMConstants {
    protected InputStream samplesIn;
    protected boolean is16bit;
    protected boolean isDone = false;
    protected boolean isSigned;
    protected ArrayList sampleStack = new ArrayList();
    protected int valpred = 0;
    protected int index = 0;

    public ADPCMEncodeStream(InputStream inputSamples, boolean is16bit, boolean isSigned) {
        this.samplesIn = inputSamples;
        this.is16bit = is16bit;
        this.isSigned = isSigned;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public int getIndex() {
        return this.index;
    }

    public int getDelta() throws IOException {
        int sign;
        int sample = this.getSample();
        int step = stepsizeTable[this.index];
        int diff = sample - this.valpred;
        int n = sign = diff < 0 ? 8 : 0;
        if (sign > 0) {
            diff = -diff;
        }
        int delta = 0;
        int vpdiff = step >> 3;
        if (diff >= step) {
            delta = 4;
            diff -= step;
            vpdiff += step;
        }
        if (diff >= (step >>= 1)) {
            delta |= 2;
            diff -= step;
            vpdiff += step;
        }
        if (diff >= (step >>= 1)) {
            delta |= 1;
            vpdiff += step;
        }
        this.valpred = sign > 0 ? (this.valpred -= vpdiff) : (this.valpred += vpdiff);
        if (this.valpred > Short.MAX_VALUE) {
            this.valpred = Short.MAX_VALUE;
        } else if (this.valpred < Short.MIN_VALUE) {
            this.valpred = Short.MIN_VALUE;
        }
        this.index += indexTable[delta |= sign];
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > 88) {
            this.index = 88;
        }
        return delta;
    }

    public int getSample() throws IOException {
        if (!this.sampleStack.isEmpty()) {
            Integer sample = (Integer)this.sampleStack.remove(this.sampleStack.size() - 1);
            return sample;
        }
        int lo = this.read();
        if (!this.is16bit) {
            return (lo -= 128) * 256;
        }
        int hi = this.read();
        hi <<= 8;
        if (this.isSigned && (hi += lo) > Short.MAX_VALUE) {
            hi -= 65536;
        }
        return hi;
    }

    protected int read() throws IOException {
        int b = this.samplesIn.read();
        if (b < 0) {
            this.isDone = true;
            b = 0;
        }
        return b;
    }

    public void pushSample(int sample) {
        this.sampleStack.add(new Integer(sample));
    }

    public int getFirstPacketSample() throws IOException {
        int sample;
        this.valpred = sample = this.getSample();
        return sample;
    }

    public int peekSample() throws IOException {
        int sample = this.getSample();
        this.pushSample(sample);
        return sample;
    }

    public int setIndex(int sample1) throws IOException {
        int step;
        int i;
        int sample2 = this.peekSample();
        int diff = sample2 - sample1;
        if (diff < 0) {
            diff = -diff;
        }
        for (i = 0; i < ADPCMConstants.stepsizeTable.length && ((step = ADPCMConstants.stepsizeTable[i]) <= diff || i <= 0); ++i) {
        }
        this.index = i - 1;
        return this.index;
    }
}

